<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', 'LaLiT Loyalty Tiers'); ?></title>
    
    <!-- Meta Tags -->
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'LaLiT Loyalty Tier program'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', 'LaLiT, Loyalty, Tiers'); ?>">
    <meta name="robots" content="<?php echo $__env->yieldContent('meta_robots', 'index, follow'); ?>">
    <?php if(View::hasSection('canonical_url')): ?>
    <link rel="canonical" href="<?php echo $__env->yieldContent('canonical_url'); ?>">
    <?php endif; ?>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Optional Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>"/>
    
    <style>
        /* Base Styles */
        body {
            font-family: 'Montserrat', sans-serif;
            color: #333;
            background-color: #f9f9f9;
        }
        
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Playfair Display', serif;
        }
        
        /* Sticky Navigation Styles */
        #sticky-page-nav {
            transition: all 0.3s ease;
            z-index: 1020;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        #sticky-page-nav .container-fluid {
            background-color: rgba(255, 255, 255, 0.97) !important;
            backdrop-filter: blur(10px);
        }
        
        #sticky-page-nav .sticky-logo img {
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link {
            color: #444;
            font-size: 0.9rem;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
            margin: 0 0.2rem;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link:hover {
            color: #c6aa76;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link.active {
            color: #c6aa76;
            font-weight: 600;
            background-color: transparent;
        }
        
        #sticky-page-nav .btn-primary {
            background-color: #c6aa76;
            border-color: #c6aa76;
            padding: 0.375rem 1rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .btn-primary:hover {
            background-color: #b09762;
            border-color: #b09762;
            transform: translateY(-2px);
        }
        
        /* Tier-specific Styles */
        .tier-header {
            padding: 4rem 0;
            background: linear-gradient(to right, #f5f0eb, #f9f9f9);
        }
        
        .section-title {
            position: relative;
            color: #212322;
            margin-bottom: 1rem;
            font-weight: 600;
        }
        
        .header-title-line {
            width: 60px;
            height: 3px;
            background-color: #c6aa76;
            margin-bottom: 30px;
        }
        
        .tier-card {
            border-radius: 8px;
            overflow: hidden;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .tier-card:hover {
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            transform: translateY(-5px);
        }
        
        .tier-icon {
            color: #c6aa76;
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }
        
        @media (max-width: 991px) {
            #sticky-page-nav .secondary-navigation {
                display: none !important;
            }
            
            #sticky-page-nav .nav-action {
                margin-left: auto;
            }
        }
        
        @media (max-width: 768px) {
            #sticky-page-nav .sticky-logo img {
                height: 32px;
            }
            
            .tier-header {
                padding: 3rem 0;
            }
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="font-sans antialiased bg-gray-50 dark:bg-gray-900">    
    <!-- Sticky Navigation -->
    <div id="sticky-page-nav" class="position-sticky top-0">
        <div class="container-fluid py-2">
            <div class="d-flex justify-content-between align-items-center">
                <div class="sticky-logo">
                    <a href="<?php echo e(route('homestatic')); ?>">
                        <img src="https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png" alt="The LaLiT Logo" style="height: 36px;">
                    </a>
                </div>
                
                <div class="secondary-navigation">
                    <ul class="nav">
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('homestatic')); ?>">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="#">Tiers</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Rewards</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Contact</a>
                        </li>
                    </ul>
                </div>
                
                <div class="nav-action">
                    <a href="#" class="btn btn-sm btn-primary">Sign In</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="py-5" style="background-color: #f5f0eb;">
        <div class="container">
            <div class="row">
                <!-- Links Sections -->
                <div class="col-lg-8 mb-4">
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6 mb-4">
                            <h5 class="mb-3" style="color: #212322;">Quick Links</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/about-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">About The LaLit Loyalty</a></li>
                                <li class="mb-2"><a href="#" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Tiers Benefits</a></li>
                                <li class="mb-2"><a href="#" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Redeem Points</a></li>
                            </ul>
                        </div>
                        
                        <!-- Second Column -->
                        <div class="col-md-6 mb-4">
                            <h5 class="mb-3" style="color: #212322;">Support</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/about-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">About Us</a></li>
                                <li class="mb-2"><a href="/faqs" class="text-decoration-none" style="color: #212322; opacity: 0.7;">FAQs</a></li>
                                <li class="mb-2"><a href="/terms-condition" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Terms & Conditions</a></li>
                                <li class="mb-2"><a href="/privacy-policy" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Privacy Policy</a></li>
                                <li class="mb-2"><a href="/contact-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter Section -->
                <div class="col-lg-4">
                    <h5 class="mb-3" style="color: #212322;">Stay Connected</h5>
                    <p class="mb-3" style="color: #212322; opacity: 0.7;">Subscribe to our newsletter for the latest updates.</p>
                    
                    <form class="mb-4">
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email" style="border-color: #c6aa76;">
                            <button class="btn btn-outline-secondary" type="button" style="background-color: #c6aa76; color: white; border-color: #c6aa76;">
                                Subscribe
                            </button>
                        </div>
                    </form>
                    
                    <!-- Social Links -->
                    <div class="social-links">
                        <a href="#" class="me-3" style="color: #212322;"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="me-3" style="color: #212322;"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="me-3" style="color: #212322;"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="me-3" style="color: #212322;"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
            
            <hr class="mt-4 mb-4" style="background-color: rgba(33, 35, 34, 0.1);">
            
            <!-- Copyright -->
            <div class="text-center">
                <p class="mb-0" style="color: #212322; opacity: 0.7;">
                    &copy; <?php echo e(date('Y')); ?> The LaLiT Loyalty. All Rights Reserved.
                </p>
            </div>
        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
      <script>
    document.addEventListener('DOMContentLoaded', function() {
        const stickyNav = document.getElementById('sticky-page-nav');
        const navLinks = document.querySelectorAll('#sticky-page-nav .nav-link');
        
        if (!stickyNav) return;
        
        // Add box shadow on scroll
        window.addEventListener('scroll', function() {
            if (window.scrollY > 10) {
                stickyNav.classList.add('scrolled');
                stickyNav.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.05)';
            } else {
                stickyNav.classList.remove('scrolled');
                stickyNav.style.boxShadow = 'none';
            }
        });
    });
    </script>
</body>
</html>
<?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/layouts/tier.blade.php ENDPATH**/ ?>