<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Tier: <?php echo e($tier->title); ?></h1>
                    <div>
                        <a href="<?php echo e(route('admin.tiers.edit', $tier)); ?>" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.tiers.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Tiers
                        </a>
                    </div>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="row mb-4">
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span>Tier Details</span>
                                <span class="badge <?php echo e($tier->status == 'published' ? 'bg-success' : ($tier->status == 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                                    <?php echo e(ucfirst($tier->status)); ?>

                                </span>
                            </div>
                            <div class="card-body">
                                <?php if($tier->featured_image || $tier->banner_image): ?>
                                <div class="row mb-4">
                                    <?php if($tier->featured_image): ?>
                                    <div class="col-md-6 mb-3">
                                        <h5>Featured Image</h5>
                                        <img src="<?php echo e(asset('storage/' . $tier->featured_image)); ?>" class="img-fluid rounded" 
                                            alt="<?php echo e($tier->featured_image_alt); ?>">
                                        <?php if($tier->featured_image_caption): ?>
                                        <p class="mt-2 text-muted"><?php echo e($tier->featured_image_caption); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if($tier->banner_image): ?>
                                    <div class="col-md-6 mb-3">
                                        <h5>Banner Image</h5>
                                        <img src="<?php echo e(asset('storage/' . $tier->banner_image)); ?>" class="img-fluid rounded" 
                                            alt="<?php echo e($tier->banner_image_alt); ?>">
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <hr>
                                <?php endif; ?>

                                <h2><?php echo e($tier->title); ?></h2>
                                
                                <?php if($tier->excerpt): ?>
                                <div class="card bg-light mb-4">
                                    <div class="card-body">
                                        <h5>Excerpt</h5>
                                        <p class="mb-0"><?php echo e($tier->excerpt); ?></p>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="mt-4">
                                    <h5>Content</h5>
                                    <div class="content-preview">
                                        <?php echo $tier->content; ?>

                                    </div>
                                </div>

                                <div class="mt-4">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Slug:</strong> <?php echo e($tier->slug); ?></p>
                                            <p><strong>Sort Order:</strong> <?php echo e($tier->sort_order); ?></p>
                                            <p>
                                                <strong>Featured:</strong> 
                                                <?php if($tier->is_featured): ?>
                                                    <span class="badge bg-primary">Yes</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">No</span>
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <p>
                                                <strong>Published Date:</strong> 
                                                <?php echo e($tier->published_at ? $tier->published_at->format('d M Y, H:i') : 'Not set'); ?>

                                            </p>
                                            <p><strong>Created:</strong> <?php echo e($tier->created_at->format('d M Y, H:i')); ?></p>
                                            <p><strong>Last Updated:</strong> <?php echo e($tier->updated_at->format('d M Y, H:i')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Author Info -->
                        <div class="card mb-4">
                            <div class="card-header">Author Information</div>
                            <div class="card-body">
                                <p><strong>Created By:</strong> <?php echo e($tier->author->name ?? 'Unknown'); ?></p>
                                <p><strong>Last Updated By:</strong> <?php echo e($tier->updatedBy->name ?? 'Unknown'); ?></p>
                            </div>
                        </div>

                        <!-- SEO Information -->
                        <div class="card mb-4">
                            <div class="card-header">SEO Information</div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong>Meta Title:</strong>
                                    <p class="mb-0"><?php echo e($tier->meta_title ?: 'Not set'); ?></p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Description:</strong>
                                    <p class="mb-0"><?php echo e($tier->meta_description ?: 'Not set'); ?></p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Keywords:</strong>
                                    <p class="mb-0"><?php echo e($tier->meta_keywords ?: 'Not set'); ?></p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Robots:</strong>
                                    <p class="mb-0"><?php echo e($tier->meta_robots ?: 'Not set'); ?></p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Canonical URL:</strong>
                                    <p class="mb-0"><?php echo e($tier->canonical_url ?: 'Not set'); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="card">
                            <div class="card-header">Actions</div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <a href="<?php echo e(route('admin.tiers.edit', $tier)); ?>" class="btn btn-primary">
                                        <i class="fas fa-edit"></i> Edit Tier
                                    </a>
                                    <form action="<?php echo e(route('admin.tiers.destroy', $tier)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger w-100" 
                                            onclick="return confirm('Are you sure you want to delete this tier? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i> Delete Tier
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .content-preview img {
        max-width: 100%;
        height: auto;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/tiers/show.blade.php ENDPATH**/ ?>