<?php $__env->startSection('title', 'Home - The LaLiT Hotels'); ?>

<?php $__env->startSection('nav-home', 'active'); ?>
<?php
use Illuminate\Support\Facades\Storage;
?>
<?php $__env->startSection('hero'); ?>
<!-- Hero Banner -->
<div class="hero-banner position-relative">
    <div class="hero-image">
        <?php if($homeData && $homeData->banner_img && Storage::disk('public')->exists($homeData->banner_img)): ?>
            <img src="<?php echo e(Storage::url($homeData->banner_img)); ?>"
                 class="w-100" alt="Hero Background" style="height: 38.563rem; object-fit: cover;">
        <?php else: ?>
            <img src="<?php echo e(asset('assets/images/hero-bg.avif')); ?>"
                 class="w-100" alt="Hero Background" style="height: 38.563rem; object-fit: cover;">
        <?php endif; ?>
    </div>
    <!-- Hero Overlay -->
    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100"
         style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.6) 100%);">
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Section for Benefits of Being a Member -->
<section class="py-5 text-center">
    <div class="container">
        <h2 class="section-title mb-3">Unlock Exclusive Benefits as a Member</h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            <?php if($homeData && $homeData->section_1 && isset($homeData->section_1['content'])): ?>
                <?php echo e($homeData->section_1['content']); ?>

            <?php endif; ?>
        </p>

        <div class="row g-4">
            <?php if($benefits->count() > 0): ?>
                <?php $__currentLoopData = $benefits->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                    <div class="benefit-card">
                        <div class="image-wrapper mb-3">
                            <?php if($benefit->featured_image && Storage::disk('public')->exists($benefit->featured_image)): ?>
                                <img src="<?php echo e(Storage::url($benefit->featured_image)); ?>"
                                     alt="<?php echo e($benefit->featured_image_alt ?: $benefit->title); ?>" class="img-fluid">
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/member-' . ($loop->index + 1) . '.avif')); ?>"
                                     alt="<?php echo e($benefit->title); ?>" class="img-fluid">
                            <?php endif; ?>
                        </div>
                        <div class="border-anima"></div>
                        <h5><?php echo e(strtoupper($benefit->title)); ?></h5>
                        <p><?php echo e($benefit->excerpt ?: strip_tags($benefit->content)); ?></p>
                        <?php if($benefit->custom_link): ?>
                        <div class="mt-3">
                            <a href="<?php echo e($benefit->custom_link); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                More Details <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <!-- Fallback to static content if no benefits are published -->
                <p>Please add benefits from admin.</p>
            <?php endif; ?>
        </div>
        <div class="mt-4">
            <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
                <a href="https://thelalitloyalty.in" target="_blank" class="btn-lg ct-btn-white">Join Now</a>
                <a href="https://thelalitloyalty.in" target="_blank" class="btn-lg ct-btn-white">Already a member - Sign in</a>
            </div>
        </div>
    </div>
</section>
<!-- Benefits of being a Member Section -->

<!-- Start The LaLiT Loyalty Section -->
<section id="rewards" class="py-5 text-center mt-5">
    <div class="container">
        <h2 class="section-title mb-3">The LaLiT Exclusive Rewards </h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            <?php if($homeData && $homeData->section_2 && isset($homeData->section_2['content'])): ?>
                <?php echo e($homeData->section_2['content']); ?>

            <?php endif; ?>
        </p>

        <div class="row g-4">
            <?php $__currentLoopData = $rewards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="<?php echo e(Storage::url($reward->featured_image)); ?>" alt="<?php echo e($reward->title); ?>"
                             class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <h6><a class="text-decoration-none text-dark fw-bold" href="<?php echo e(route('pages.rewards', $reward->slug)); ?>"><?php echo e(strtoupper($reward->title)); ?></a></h6>
                    <p><?php echo e($reward->excerpt); ?></p>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <!-- Card 1 -->
            

            <!-- Card 2 -->
            

            <!-- Card 3 -->
            

            <!-- Card 4 -->
            
        </div>
        
    </div>
</section>
<!-- End The LaLiT Loyalty Section -->

<!-- Start Points Section -->
<?php
    $i = 0;
?>
<?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if($i++ % 2 == 0): ?>
        <section class="py-5">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="<?php echo e(Storage::url($point->featured_image)); ?>"
                            alt="<?php echo e($point->title); ?>" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4"><?php echo e($point->title); ?></h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            <?php echo e($point->excerpt); ?>

                        </p>
                        <div class="mt-4">
                            <a href="<?php echo e(route('pages.points', $point->slug)); ?>" class="ct-btn-white btn-lg d-inline-block text-center">
                                More Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php else: ?> 
    <section class="py-5">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4"><?php echo e($point->title); ?></h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            <?php echo e($point->excerpt); ?>

                        </p>
                        <div class="mt-4">
                            <a href="<?php echo e(route('pages.points', $point->slug)); ?>" class="ct-btn-white btn-lg d-inline-block text-center">
                                More Details
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="<?php echo e(Storage::url($point->featured_image)); ?>"
                            alt="<?php echo e($point->title); ?>" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<!-- End Donate Points Section -->

<!-- Start Membership Tiers Section -->
<section id="membership-tier" class="py-5 text-center" style="background-color: #f5f0eb;">
    <div class="container">
        <h2 class="section-title mb-3">The Lalit Loyalty Membership Tiers </h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            <?php if($homeData && $homeData->section_3 && isset($homeData->section_3['content'])): ?>
                <?php echo e($homeData->section_3['content']); ?>

            <?php endif; ?>
        </p>

        <div class="row g-4">
            <?php $__currentLoopData = $tiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="<?php echo e(Storage::url($tier->featured_image)); ?>" alt="Fine Dining" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <div class="content">
                        <h6 class="font-bold"><?php echo e($tier->title); ?></h6>
                        <p><?php echo e($tier->excerpt); ?></p>
                        <div class="content-tier"><?php echo $tier->content; ?></div>
                    </div>
                    <div class="mt-3">
                        <a href="/package-details" class="ct-btn-white btn-lg d-inline-block text-center">
                            Explore <?php echo e($tier->title); ?>

                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
        </div>
    </div>
</section>
<!-- End Membership Tiers Section -->

<!-- Start Discover The Lalit Loyality Section -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center g-5">
            <div class="col-lg-8">
                <div class="image-wrapper">
                    <?php if($homeData && isset($homeData->section_5['image']) && Storage::disk('public')->exists($homeData->section_5['image'])): ?>
                        <img src="<?php echo e(Storage::url($homeData->section_5['image'])); ?>"
                             alt="Discover The LaLiT Loyalty" class="img-fluid rounded shadow-lg">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="content-wrapper">
                    <h2 class="section-title mb-4">Discover The LaLiT Loyalty</h2>
                    <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                    <?php if($homeData && $homeData->section_5 && isset($homeData->section_5['content'])): ?>
                        <?php echo $homeData->section_5['content']; ?>

                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Discover The Lalit Loyality Section -->

<!-- Start Help and Support Section -->
<section class="py-5 text-center">
    <div class="container">
        <h2 class="section-title mb-3">Help & Support</h2>
        <div class="header-title-line"></div>
        <p class="section-subtitle mb-4 mt-3">
            <?php if($homeData && $homeData->section_4 && isset($homeData->section_4['content'])): ?>
                <?php echo e($homeData->section_4['content']); ?>

            <?php endif; ?>
        </p>
        <div class="mt-4 d-flex justify-content-center gap-3">
          <a href="tel:01144447621" class="ct-btn-white btn-lg">
              <i class="fa-solid fa-phone"></i> Call Us
          </a>
          <a href="mailto:priority@thelalitloyalty.com" class="ct-btn-white btn-lg">
              <i class="fa-solid fa-envelope"></i> Email Us
          </a>
        </div>
    </div>
</section>
<!-- End Help and Support Section -->

<!-- Start About Us Section -->

<!-- End About Us Section -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/homestatic.blade.php ENDPATH**/ ?>