<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', 'The LaLiT Hotels'); ?></title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Optional Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>"/>    <style>
        /* Mobile Navigation Styles */
        .mobile-nav-link {
            color: #212322 !important;
            font-weight: 500;
        }
        
        .offcanvas .nav-link.mobile-nav-link {
            color: #212322 !important;
        }
        
        .offcanvas .nav-link.mobile-nav-link:hover,
        .offcanvas .nav-link.mobile-nav-link:focus {
            color: #c6aa76 !important;
        }
        
        /* Sticky Navigation Styles */
        #sticky-page-nav {
            transition: all 0.3s ease;
            z-index: 1020;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        #sticky-page-nav .container-fluid {
            background-color: rgba(255, 255, 255, 0.97) !important;
            backdrop-filter: blur(10px);
        }
        
        #sticky-page-nav .sticky-logo img {
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link {
            color: #444;
            font-size: 0.9rem;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
            margin: 0 0.2rem;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link:hover {
            color: #c6aa76;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link.active {
            color: #c6aa76;
            font-weight: 600;
            background-color: transparent;
        }

        #sticky-page-nav .btn-primary {
            background-color: #c6aa76;
            border-color: #c6aa76;
            padding: 0.375rem 1rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .btn-primary:hover {
            background-color: #b09762;
            border-color: #b09762;
            transform: translateY(-2px);
        }
        
        @media (max-width: 991px) {
            #sticky-page-nav .secondary-navigation {
                display: none !important;
            }
            
            #sticky-page-nav .nav-action {
                margin-left: auto;
            }
        }
        
        @media (max-width: 768px) {
            #sticky-page-nav .sticky-logo img {
                height: 32px;
            }
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="body-layout font-sans antialiased bg-gray-50 dark:bg-gray-900">
    <header>
        <!-- Primary Navigation Header -->
        <div class="carousel-nav-menu px-3">
            <div class="d-flex justify-content-between align-items-center py-2">
                <!-- Left Side - Toggle Button for Mobile / Empty space for Desktop -->
                <div class="nav-left">
                    <button class="btn btn-outline-light d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu">
                        ☰
                    </button>
                    <!-- Empty space for desktop to balance layout -->
                    <div class="d-none d-lg-block" style="width: 200px;"></div>
                </div>
                
                <!-- Center Logo -->
                <div class="logo">
                    <a href="/">
                        <img src="<?php echo e(asset('assets/images/logo-white-lalit.png')); ?>" alt="Logo" class="img-fluid">
                    </a>
                </div>

                <!-- Right Side - Desktop Menu / Mobile Login -->
                <div class="nav-right">                    
                  <!-- Desktop Menu -->
                    <ul class="nav nav-pills d-none d-lg-flex">
                        <li class="nav-item">
                            <a href="https://thelalitloyalty.in" class="nav-link">
                                Login
                            </a>
                        </li>
                        <li class="nav-item"><a class="nav-link" href="https://www.thelalit.com/">Book your stay</a></li>
                      </ul>

                    <!-- Login Button for Mobile (visible only on mobile) -->
                    <div class="d-lg-none">
                        <a target="_blank" href="https://thelalitloyalty.in" class="btn btn-outline-light btn-sm">
                            Login
                        </a>
                    </div>
                </div>
            </div>

            <!-- Secondary Navigation Header -->
            <div class="secondary-nav" style="height: 3.5rem;">
                <div class="container-fluid px-3">
                    <div class="d-flex justify-content-center align-items-center h-100">
                        <!-- Secondary Navigation Links -->                        
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership Tiers</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Offcanvas Menu -->
        <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title">The Lalit</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
            </div>            
            <div class="offcanvas-body d-flex flex-column">                
                <ul class="nav nav-pills flex-column">
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership Tiers</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
                </ul>
                  <!-- Mobile Menu Footer -->
                <div class="mt-auto pt-4 border-top">
                    <div class="d-flex flex-column gap-2">
                        <a href="https://thelalitloyalty.in" target="_blank" class="ct-btn btn-sm text-center">Login</a>
                        <a href="https://www.thelalit.com/" target="_blank" class="ct-btn btn-sm text-center">Book Your Stay</a>
                    </div>
                </div>
            </div>
        </div>

        <?php if (! empty(trim($__env->yieldContent('hero')))): ?>
          <?php echo $__env->yieldContent('hero'); ?>
        <?php endif; ?>
    </header>

    <!-- Sticky Page Navigation -->
    <div id="sticky-page-nav" class="sticky-top d-none">
        <div class="container-fluid py-2 bg-white border-bottom shadow-sm">
            <div class="container">
                <!-- Main Navigation Row -->
                <div class="d-flex justify-content-between align-items-center">
                    <!-- Logo instead of page title -->
                    <div class="sticky-logo">
                        <a href="<?php echo e(route('homestatic')); ?>">
                            <img src="<?php echo e(asset('assets/images/logo-black-lalit.png')); ?>" alt="Logo" class="img-fluid" style="height: 40px;">
                        </a>
                    </div>
                    
                    <!-- Secondary Navigation Links -->
                    <nav class="secondary-navigation d-none d-lg-block">
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership Tiers</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
                        </ul>
                    </nav>
                    
                    <div class="nav-action">
                        <a href="https://www.thelalit.com/" class="btn btn-sm btn-primary">Join Now</a>
                    </div>
                </div>
                

            </div>
        </div>
    </div>

    <!-- Page Title Section - Will be shown on mobile views -->
    <?php if (! empty(trim($__env->yieldContent('page_title')))): ?>
        <div class="page-title-container d-md-none bg-white py-3">
            <div class="container">
                <h1 class="page-title"><?php echo $__env->yieldContent('page_title'); ?></h1>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="py-5" style="background-color: #f5f0eb;">
        <div class="container">
            <div class="row">
                <!-- Links Sections -->
                <div class="col-lg-8 mb-4">
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6 mb-4">
                            <h5 class="mb-3" style="color: #212322;">Quick Links</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/about-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">About The LaLit Loyalty</a></li>
                                <li class="mb-2"><a href="/contact-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Contact Us</a></li>
                                <li class="mb-2"><a href="<?php echo e(asset('assets/files/FAQ-The-LaLiT-Loyalty-Program.pdf')); ?>" target="_blank" class="text-decoration-none" style="color: #212322; opacity: 0.7;">FAQs</a></li>
                                <li class="mb-2"><a href="<?php echo e(asset('assets/files/TnC-The-Lalit-Loyalty-Program.pdf')); ?>" target="_blank" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Terms & Conditions</a></li>
                                <li class="mb-2"><a href="/privacy-policy" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Privacy Policy</a></li>
                            </ul>
                        </div>
                        
                        <!-- Second Column -->
                        <div class="col-md-6 mb-4">
                            <ul class="list-unstyled">
                            </ul>
                        </div>
                    </div>
                </div>
                
                <!-- Social Media Section -->
                
            </div>
            
            <!-- Copyright Section -->
            <hr class="my-4 border-secondary">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0" style="color: #212322; opacity: 0.7;">&copy; <?php echo e(date('Y')); ?> The LaLiT Hotels. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <img src="<?php echo e(asset('assets/images/logo-black-lalit.png')); ?>" alt="Logo" class="img-fluid" style="max-height: 100px;">
                </div>
            </div>        
          </div>
    </footer>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">            
          <div class="modal-content" style="border-radius: 12px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">                <div class="modal-header text-center position-relative" style="background-color: #f5f0eb; border-bottom: 1px solid #e5e5e5; border-radius: 12px 12px 0 0; padding: 1.5rem 1.5rem;">
                    <button type="button" class="btn-close position-absolute top-0 end-0 mt-3 me-3" data-bs-dismiss="modal" aria-label="Close"></button>
                    <h5 class="modal-title fw-semibold mb-0 w-100" style="color: #212322;">Sign in to your LaLiT account</h5>
                </div>
                <div class="modal-body p-4" style="background-color: #fff;">
                    
                    <form id="loginForm" action="#" method="POST">
                        <div class="mb-3">
                            <label for="loginEmail" class="form-label fw-semibold" style="color: #212322;">Email Address</label>
                            <input type="email" class="form-control form-control-lg" id="loginEmail" placeholder="Enter your email address" style="border: 2px solid #e5e5e5; border-radius: 8px; padding: 12px 16px;">
                        </div>
                        
                        <div class="mb-4">
                            <label for="loginPassword" class="form-label fw-semibold" style="color: #212322;">Password</label>
                            <input type="password" class="form-control form-control-lg" id="loginPassword" placeholder="Enter your password" style="border: 2px solid #e5e5e5; border-radius: 8px; padding: 12px 16px;">
                        </div>
                          <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-lg fw-semibold" style="background-color: #212322; color: #fff; border: none; border-radius: 8px; padding: 8px 24px; transition: all 0.3s ease;">
                                Sign In
                            </button>
                            
                            <button type="button" class="btn btn-outline-dark btn-lg fw-semibold" style="border: 2px solid #c6aa76; color: #c6aa76; border-radius: 8px; padding: 8px 24px; transition: all 0.3s ease;">
                                Join Now
                            </button>
                        </div>
                        
                        <div class="text-center mt-4">
                            <a href="#" class="text-muted text-decoration-none small">Forgot your password?</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const header = document.querySelector('header');
        const stickyNav = document.getElementById('sticky-page-nav');
        const navLinks = document.querySelectorAll('#sticky-page-nav .nav-link');
        
        // Fix for mobile navigation links in off-canvas menu
        const mobileNavLinks = document.querySelectorAll('.mobile-nav-link');
        const offcanvasMenu = document.getElementById('offcanvasMenu');
        
        mobileNavLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const href = this.getAttribute('href');
                const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasMenu);
                
                // If it's a hash link, handle special navigation
                if (href.startsWith('#')) {
                    e.preventDefault();
                    
                    // Close the offcanvas menu
                    if (bsOffcanvas) {
                        bsOffcanvas.hide();
                        
                        // Wait for offcanvas to close before scrolling
                        offcanvasMenu.addEventListener('hidden.bs.offcanvas', function scrollToTarget() {
                            const targetElement = document.querySelector(href);
                            if (targetElement) {
                                setTimeout(() => {
                                    window.scrollTo({
                                        top: targetElement.offsetTop - 100,
                                        behavior: 'smooth'
                                    });
                                }, 150);
                            }
                            // Remove event listener to avoid multiple executions
                            offcanvasMenu.removeEventListener('hidden.bs.offcanvas', scrollToTarget);
                        });
                    }
                } else {
                    // For non-hash links, just close the menu (default navigation will happen)
                    if (bsOffcanvas) {
                        bsOffcanvas.hide();
                    }
                }
            });
        });
        
        // Handle scrolling events to show/hide sticky menu
        window.addEventListener('scroll', function() {
            if (!header) return;
            
            const headerBottom = header.getBoundingClientRect().bottom;
            
            // Show sticky nav when scrolled past header
            if (headerBottom <= 0) {
                stickyNav.classList.remove('d-none');
            } else {
                stickyNav.classList.add('d-none');
            }
        });
        
        // Handle navigation link clicks for smooth scrolling
        navLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const targetId = this.getAttribute('href');
                if (targetId && targetId.startsWith('#')) {
                    e.preventDefault();
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        // Calculate offset with sticky nav height
                        const stickyNavHeight = stickyNav.offsetHeight;
                        const targetPosition = targetElement.getBoundingClientRect().top + window.scrollY - stickyNavHeight;
                        
                        // Smooth scroll to target position
                        window.scrollTo({
                            top: targetPosition,
                            behavior: 'smooth'
                        });
                        
                        // Update active state for secondary navigation only
                        navLinks.forEach(link => link.classList.remove('active'));
                        this.classList.add('active');
                    }
                }
            });
        });
        
        // No need for section-based active link detection now that we've removed section navigation
        
    });
    </script>
</body>
</html>
<?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/layouts/home.blade.php ENDPATH**/ ?>