<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Property Data</a></li>
    </ol>
</div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Property Data</h4>
            </div>
            <div class="card-body">
                <form action="<?= ADMIN_URL . 'property/save' ?>" method="post" enctype="multipart/form-data">
                    <?php if (isset($property_data['id'])) { ?>
                        <?php if (!empty($property_data['id'])) { ?>
                            <input type="hidden" name="id" value="<?= $property_data['id'] ?>">
                        <?php } ?>
                    <?php } ?>
                    <div class="row">
                        <div class="mb-3 col-lg-6 col-md-6 col-sm-12">
                            <label class="form-label">Property Title</label>
                            <input type="text" class="form-control" placeholder="Title" required="" value="<?= $property_data['title'] ?? '' ?>" name="title">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Property Type</label>
                            <select class="form-control form-select" name="type">
                                <option value="">Select</option>
                                <?php foreach ($propertyType as $pk => $pv) { ?>
                                    <option value="<?= $pv['id']; ?>" <?= ($pv['id'] == $property_data['type'] ? 'selected' : '') ?>><?= $pv['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Youtube Video Id</label>
                            <input type="text" class="form-control" placeholder="Youtube Video Id" value="<?= $property_data['video_id'] ?? '' ?>" name="video">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Bedrooms</label>
                            <input type="text" class="form-control" placeholder="Bedrooms" required="" value="<?= $property_data['beds'] ?? '' ?>" name="bedroom">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Bathrooms</label>
                            <input type="text" class="form-control" placeholder="Bathrooms" required="" value="<?= $property_data['bath'] ?? '' ?>" name="bathroom">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Guest</label>
                            <input type="text" class="form-control" placeholder="Guest" required="" value="<?= $property_data['guest'] ?? '' ?>" name="guest">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Max Sleep</label>
                            <input type="text" class="form-control" placeholder="Max Sleeps" required="" value="<?= $property_data['max_stay'] ?? '' ?>" name="max_sleep">
                        </div>

                        <div class="mb-3 col-lg-12 col-md-12 col-sm-12">
                            <label class="form-label">Property Description</label>
                            <textarea name="desc" class="form-control" rows="3" placeholder="Property Description" id="desc" required=""><?= $property_data['description'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Facebook</label>
                            <input type="text" class="form-control" placeholder="Facebook Link" value="<?= $property_data['facebook_link'] ?? '' ?>" name="facebook">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Twitter</label>
                            <input type="text" class="form-control" placeholder="Twitter Link" value="<?= $property_data['twitter_link'] ?? '' ?>" name="twitter">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Instagram</label>
                            <input type="text" class="form-control" placeholder="Instagram Link" value="<?= $property_data['instagram_link'] ?? '' ?>" name="instagram">
                        </div>
                        <div class="mb-3 col-lg-3 col-md-3 col-sm-12">
                            <label class="form-label">Youtube</label>
                            <input type="text" class="form-control" placeholder="Youtube Link" value="<?= $property_data['youtube_link'] ?? '' ?>" name="youtube">
                        </div>
                        <div class="mb-3 col-lg-12 col-md-12 col-sm-12">
                            <label class="form-label">Copyright Text</label>
                            <input type="text" class="form-control" placeholder="Copyright Text" value="<?= $property_data['copyright_text'] ?? '' ?>" name="copyright">
                        </div>
                        <div class="mb-3 col-12">
                            <div class="col-sm-12 pt-3">
                                <input type="submit" class="btn btn-sm btn-primary me-2" name="register_property" value="Submit">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src='https://cdn.ckeditor.com/4.14.0/full-all/ckeditor.js'></script>
<script>
    var editor = CKEDITOR.replace('desc', {
        height: 300,
        extraPlugins: 'mentions',
        filebrowserUploadUrl: '/uploader/upload.php',
    });
</script>