<link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<style>
    #datepicker {
        display: flex;
        justify-content: center;
    }

    .ui-datepicker {
        width: 100% !important;
    }

    .ui-widget.ui-widget-content {
        border: none;
    }

    .ui-datepicker td {
        border: 0;
        padding: 2px;
    }

    .ui-state-default {
        background: #7cdbe3 !important;
        text-align: center !important;
        border: none !important;
        padding: 5px !important;
        color: #ffffff !important;
    }

    .ui-state-default.ui-state-highlight {

        background: #70ebb0 !important;
    }

    .ui-state-default.ui-state-active {
        background: #f8e707 !important;

    }

    .ui-state-default.ui-state-hover {
        background: #00b4ff !important;
    }

    .ui-datepicker-multi .ui-datepicker-buttonpane {
        display: none;
    }

    .ui-state-disabled .ui-state-default {

        background: #f18085 !important;
    }

    #rates-page table {

        box-shadow: none;
    }

    .ui-widget-content {

        border: none;
    }

    .ui-datepicker .ui-datepicker-header {
        position: relative;
        padding: 2px 4px;
        color: #fff;
        background: #4dabe9;
    }

    @media (max-width: 576px) {
        .ui-datepicker-group {
            width: 100% !important;
        }
    }

    .card {
        width: auto;
        padding: 10px 15px;
        border: 2px solid #57b8e2;
        border-radius: 12px;
    }

    .datepicker table {
        background-color: #fff;
    }

    .datepicker table tr td {
        font-family: "Roboto Condensed", Sans-serif;
        background-color: #43a4e4 !important;
        color: #fff !important;
    }

    .datepicker table tr td.disabled {
        background-color: #fa6396 !important;
        color: #fff !important;
    }

    .datepicker table tr td.today {
        background-color: #31e482 !important;
        background-image: linear-gradient(to bottom, #31e482, #31e482) !important;
    }

    .card-title {
        font-family: "Roboto Condensed", Sans-serif;
        font-weight: 600;
        line-height: 1px;
        font-size: 32px;
        text-align: center;
        color: #57b8e2;
        padding: 10px 15px;
    }

    .get_quote_btn_box {
        justify-content: center;
        display: flex;
    }

    .get_quote {
        background-color: #57b8e2;
        border-color: #57b8e2;
    }
</style>

<div class="page-header">
    <h3>Rates & Availability</h3>
</div>
<div id="rates-page" class="  mt-5">
    <div class="container">
        <div class="row" style="margin-bottom:20px;">
            <div class="col-lg-9 col-md-9 col-sm-12">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <tbody>
                            <tr class="rates-header">
                                <td>In Season</td>
                                <td>Persons</td>
                                <td>Date From</td>
                                <td>Date To</td>
                                <td>Per Night</td>
                                <td>Weekend Night</td>
                                <td>Weekly</td>
                                <td>Monthly</td>
                            </tr>
                            <?php foreach ($rates as $rs) { ?>
                                <tr class="rates-body">
                                    <td><?= $rs['seasonname'] ?></td>
                                    <td><?= $rs['minimumpersons'] ?></td>
                                    <td><?= date('d, M Y', strtotime($rs['fromdate'])) ?></td>
                                    <td><?= date('d, M Y', strtotime($rs['todate'])) ?></td>
                                    <td><?= !empty($rs['nightly']) ? '$' . $rs['nightly'] : '-' ?></td>
                                    <td><?= !empty($rs['weekend']) ? '$' . $rs['weekend'] : '-' ?></td>
                                    <td><?= !empty($rs['weekly']) ? '$' . $rs['weekly'] : '-' ?></td>
                                    <td><?= !empty($rs['monthly']) ? '$' . $rs['monthly'] : '-' ?></td>
                                </tr>
                            <?php } ?>
                            <tr>
                                <td colspan="8">
                                    ADDITIONAL INFORMATION ABOUT RENTAL RATES
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    Tax(%)
                                </td>
                                <td colspan="4">
                                    Service Fee(%)
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <?= $property_data['tax'] . '%'; ?>
                                </td>
                                <td colspan="4">
                                    <?= $property_data['service_fee'] . '%'; ?>
                                </td>
                            </tr>
                            <tr class="rates-footer">

                                <td colspan="8" style="text-align:left;">
                                    <h4>Note</h4>
                                    <?= html_entity_decode($property_data['rate_note']); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12 mb-5">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Instant Quote</h5>
                        <form method="post" action="<?= SITE_URL . 'rates/get-quote' ?>">
                            <div class="form-group">
                                <div class='input-group date' id='startDate'>
                                    <input type="text" class="form-control start_date" placeholder="Check In" required="" value="<?= $property_rates_edit['fromdate'] ?? '' ?>" name="from">
                                    <span class="input-group-addon input-group-text">
                                        <span class="fa fa-calendar"></span>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class='input-group date' id='endDate'>
                                    <input type="text" class="form-control end_date" placeholder="Check Out" required="" value="<?= $property_rates_edit['todate'] ?? '' ?>" name="to">
                                    <span class="input-group-addon input-group-text">
                                        <span class="fa fa-calendar"></span>
                                    </span>
                                </div>
                            </div>
                            <div class="btn-group get_quote_btn_box">
                                <button type="submit" class="btn btn-primary get_quote">Get Quote</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <div id="datepicker"></div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    var disabledDays = [<?php echo $totaldayslist1; ?>];
    var startday = [<?php echo $startday; ?>];
    var endday = [<?php echo $endday; ?>];

    jQuery.datepicker.setDefaults({
        "closeText": "Close",
        "currentText": "Today",
        "monthNames": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
        "monthNamesShort": ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
        "nextText": "Next",
        "prevText": "Previous",
        "dayNames": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
        "dayNamesShort": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
        "dayNamesMin": ["Su", "M", "T", "W", "T", "F", "Sa"],
        "dateFormat": "MM d, yy",
        "isRTL": false
    });

    $("#datepicker").datepicker({
        numberOfMonths: 2,
        showButtonPanel: true,
        minDate: new Date(),
        beforeShowDay: function(date) {
            var m = ("0" + (date.getMonth() + 1)).slice(-2),
                d = ("0" + (date.getDate())).slice(-2),
                y = date.getFullYear();
            for (i = 0; i < disabledDays.length; i++) {

                if ($.inArray(y + '-' + (m) + '-' + d, disabledDays) != -1) {
                    //return [false];
                    return [true, 'ui-datepicker-unselectable ui-state-disabled booked getdate', y + '-' + (1) + '-' + d, startday];
                } else {
                    return [true, 'not-booked getdate', y + '-' + (m) + '-' + d, startday];
                }
            }
            return [true];
        },
        dateFormat: 'yy-mm-dd',
    });
</script>

<link href="<?= SITE_URL ?>public/admin/assets/vendor/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" rel="stylesheet">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/bootstrap-datepicker-master/js/bootstrap-datepicker.min.js"></script>
<script>
    var date = new Date();
    date.setDate(date.getDate());
    $('#startDate').datepicker({
        format: 'yyyy-mm-dd',
        startDate: date,
        todayHighlight: 'TRUE',
        autoclose: true,
        beforeShowDay: function(date) {
            dmy = date.getDate() + "-" + (date.getMonth() + 1) + "-" + date.getFullYear();
            if (disabledDays.indexOf(dmy) != -1) {
                return false;
            } else {
                return true;
            }
        }
    }).on('changeDate', function(ev) {
        $('.start_date').val($('#startDate').data().datepicker.getFormattedDate('yyyy-mm-dd'));
    });

    $('#endDate').datepicker({
        format: 'yyyy-mm-dd',
        startDate: date,
        todayHighlight: 'TRUE',
        autoclose: true,
        beforeShowDay: function(date) {
            dmy = date.getDate() + "-" + (date.getMonth() + 1) + "-" + date.getFullYear();
            if (disabledDays.indexOf(dmy) != -1) {
                return false;
            } else {
                return true;
            }
        }
    }).on('changeDate', function() {
        $('.end_date').val($('#endDate').data().datepicker.getFormattedDate('yyyy-mm-dd'));
    });
</script>