<?php
require_once APP_DIR . 'libs/View.php';
require_once APP_DIR . 'libs/Input.php';
require_once APP_DIR . 'libs/Database.php';
class IndexController
{
    private $_view;
    private $_db;

    public function __construct()
    {
        $this->_view  = new View();
        $this->_db = new Database();
    }

    public function index()
    {
        $sql = "SELECT * FROM " . SLIDER . " WHERE 1 AND status = 1 ";
        $this->_db->query($sql);
        $slider_list = $this->_db->getAll();

        $sql = "SELECT * FROM " . PROPERTY_GALLERY_LIST . " WHERE 1  ORDER BY RAND() LIMIT 6";
        $this->_db->query($sql);
        $gallery_list = $this->_db->getAll();

        $sql = "SELECT * FROM " . PROPERTY_TYPE . " WHERE 1";
        $this->_db->query($sql);
        $property_type = $this->_db->getAll();
        $property_types = array_column($property_type,  'name', 'id');

        $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1  AND id = 1";
        $this->_db->query($sql);
        $property_data = $this->_db->single();

        $sql = "SELECT * FROM " . PAGE_DATA . " WHERE 1  AND id = 1";
        $this->_db->query($sql);
        $page_data = $this->_db->single();


        $this->_view->setVal('property_type', $property_types);
        $this->_view->setVal('slider_list', $slider_list);
        $this->_view->setVal('gallery_list', $gallery_list);
        $this->_view->setVal('property_data', $property_data);
        $this->_view->setVal('page_data', $page_data);
        $this->_view->setVal('favicon', '');
        $this->_view->setVal('site_logo', '');
        $this->_view->setVal('media_id', '');
        $this->_view->setVal('meta_title', '');
        $this->_view->setVal('meta_description', '');
        $this->_view->setVal('meta_keyword', '');
        $this->_view->renderFront(VIEW_DIR . 'index');
    }

    public function sendEnquiry()
    {
        $first_name = $_POST['first'];
        $last_name = $_POST['last'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $hear_us = $_POST['hear_us'];
        $message = $_POST['message'];

        if (empty($first_name)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill First Name']);
            exit;
        }
        if (empty($last_name)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Last Name']);
            exit;
        }
        if (empty($email)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Email Address']);
            exit;
        }
        if (empty($phone)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Mobile Number']);
            exit;
        }
        if (empty($hear_us)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Hear Us Field']);
            exit;
        }
        if (empty($message)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Message']);
            exit;
        }

        $full_name = htmlspecialchars($first_name) . ' ' . htmlspecialchars($last_name);
        $data = [
            'name' => $full_name,
            'email' => htmlspecialchars($email),
            'mobile' => htmlspecialchars($phone),
            'hear_us' => htmlspecialchars($hear_us),
            'message' => htmlspecialchars($message),
            'created_at' =>  date('Y-m-d h:i:s'),
        ];

        $insert_bind_colum = '';
        $insert_colum_keys = array_keys($data);
        $insert_colum =  implode(',', $insert_colum_keys);
        foreach ($data as $uk => $uv) {
            if ($uk != end($insert_colum_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $insert_bind_colum .= "'" . $uv . "'" . $separator;
        }
        $sql = " INSERT INTO " . CONTACT_FORM . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";

        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {

            $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1 AND id = 1";
            $this->_db->query($sql);
            $property_data = $this->_db->single();



            $sql = "SELECT * FROM " . SETTINGS . " WHERE 1 AND id = 1";
            $this->_db->query($sql);
            $settings = $this->_db->single();

            // Subject
            $subject =   $full_name . 'Booking Appointment Enquiry ';
            // Message

            $message = '<html>
            <head>
            <title>Booking Appointment Enquiry</title>
            </head>
            <body>
            <p>Booking Appointment Enquiry</p>
            <table>
                <tr>
                <td>Name</td><td>' . $full_name . '</td>
                </tr>
                <tr>
                <td>Email</td><td>' . $email . '</td>
                </tr>
                <tr>
                <td>Phone Number</td><td>' . $phone . '</td>
                </tr>
                <tr>
                <td>Hear About Us</td><td>' . $hear_us . '</td>
                </tr>
                <tr>
                <td>Message</td><td>' . $message . '</td>
                </tr>
            </table>
            </body>
            </html>';

            // To send HTML mail, the Content-type header must be set
            $headers[] = 'MIME-Version: 1.0';
            $headers[] = 'Content-type: text/html; charset=iso-8859-1';
            $headers[] = 'To: ' . $settings['mail_to_name'] . ' ' . $settings['mail_to'];
            $headers[] = 'From: ' . $settings['mail_from_name'] . ' ' . $settings['mail_from'];
            // Mail it
            mail(MAILER_TO_INFO, $subject, $message, implode("\r\n", $headers));

            $user_subject = 'Booking Appointment Response';
            $user_message = 'Thanks for contacting with us, we will reach you shortly.';
            $user_headers[] = 'MIME-Version: 1.0';
            $user_headers[] = 'Content-type: text/html; charset=iso-8859-1';
            $user_headers[] = 'To: ' . $full_name . ' ' . $email;
            $user_headers[] = 'From: ' . $settings['mail_from_name'] . ' ' . $settings['mail_from'];
            mail($email, $user_subject, $user_message, implode("\r\n", $user_headers));


            $type = 'success';
            $msg = 'Enquiry Send Successfully ';
        } else {
            $type   = "error";
            $msg = "Unable to send Enquiry!!";
        }

        echo json_encode(['status' => $type, 'msg' => $msg]);
        exit;
    }
}
