<?php

require_once APP_DIR . 'libs/View.php';

require_once APP_DIR . 'libs/Input.php';
require_once APP_DIR . 'libs/Database.php';

require_once APP_DIR . 'libs/Session.php';

require_once APP_DIR . 'models/AuthModel.php';

class AccountController

{

    private $_view;

    private $_db;
    public function __construct()
    {
        check_login('index');
        $this->_view  = new View();
        $this->_db = new Database();
    }



    public function index()
    {

        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {

            $authObj = new AuthModel();

            $login_user_data = $authObj->getUserDetails($user_id);

            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $this->_view->setVal('title', 'Manage Account');

        $this->_view->setVal('meta_title', 'Manage Account');

        $this->_view->setVal('meta_description', 'Manage Account');

        $this->_view->setVal('meta_keyword', 'Manage Account');

        $this->_view->renderAdmin('profile');
    }

    public function saveAccount()
    {
        $name = $_POST['user_name'];
        $screen_name = $_POST['screen_name'];

        $user_id = SESSION::get('uId');

        $data = [
            'username' => $name,
            'screen_name' => $screen_name,
        ];


        $data['upload_date'] =  date('Y-m-d h:i:s');
        $update_coloum = '';
        $updated_coloms_keys = array_keys($data);
        foreach ($data as $uk => $uv) {
            if ($uk != end($updated_coloms_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
        }

        $sql = "UPDATE " . USERS . " SET " . $update_coloum . " WHERE id = " . $user_id;
        $mode = 'Updated';
        $url = 'profile';


        $type   = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {

            $type = 'success';
            $msg = 'Profile Successfully ' . $mode;

            set_session_alert($type, $msg);
            redirect(ADMIN_URL . 'logout');
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Profile!!";

            set_session_alert($type, $msg);
            redirect(ADMIN_URL . 'account');
        }
    }


    public function changePassword()
    {

        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {

            $authObj = new AuthModel();

            $login_user_data = $authObj->getUserDetails($user_id);

            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $this->_view->setVal('title', 'Change Password');

        $this->_view->setVal('meta_title', 'Change Password');

        $this->_view->setVal('meta_description', 'Change Password');

        $this->_view->setVal('meta_keyword', 'Change Password');

        $this->_view->renderAdmin('change-password');
    }

    public function updatePassword()
    {

        $user_id = SESSION::get('uId');
        $old_password = $_POST['old_password'];
        $new_password = $_POST['new_password'];
        $re_new_password = $_POST['re_new_password'];

        $authObj = new AuthModel();
        $authObj->_set_colum = "id, password";
        $u_exist = $authObj->checkUser('id', $user_id);
        $check_password = password_verify($old_password, $u_exist['password']);
        if ($check_password) {
            if ($new_password == $re_new_password) {
                $password = password_hash($new_password, PASSWORD_DEFAULT);
                $data = [
                    'password' => $password,
                ];
                $data['upload_date'] =  date('Y-m-d h:i:s');
                $update_coloum = '';
                $updated_coloms_keys = array_keys($data);
                foreach ($data as $uk => $uv) {
                    if ($uk != end($updated_coloms_keys)) {
                        $separator = ',';
                    } else {
                        $separator = '';
                    }
                    $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
                }

                $sql = "UPDATE " . USERS . " SET " . $update_coloum . " WHERE id = " . $user_id;
                $mode = 'Updated';
                try {
                    $this->_db->query($sql);
                    $results = $this->_db->execute();
                } catch (Exception $e) {
                    $msg  = $e->getMessage();
                    $results = 0;
                }
                if ($results) {
                    $type = 'success';
                    $msg = 'Password Successfully ' . $mode;
                    set_session_alert($type, $msg);
                    redirect(ADMIN_URL . 'logout');
                } else {
                    $type   = "error";
                    $msg = "Unable to " . $mode . " Password!!";
                }
            } else {
                $type   = "error";
                $msg = "Please Enter New Password and Re Enter password!!";
            }
        } else {
            $type   = "error";
            $msg = "Please Enter Correct Password to update!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'account/change-password');
    }

    public function settings()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }


        $sql = "SELECT * FROM " . SETTINGS . " WHERE 1 AND id = 1";
        $this->_db->query($sql);
        $settings = $this->_db->single();

        $this->_view->setVal('settings', $settings);
        $this->_view->setVal('title', 'Manage Settings');
        $this->_view->setVal('meta_title', 'Manage Settings');
        $this->_view->setVal('meta_description', 'Manage Settings');
        $this->_view->setVal('meta_keyword', 'Manage Settings');
        $this->_view->renderAdmin('settings');
    }

    public function saveSettings()
    {
        $mail_from_name = $_POST['from_name'];
        $mail_from =  $_POST['from_email'];
        $mail_to_name = $_POST['to_name'];
        $mail_to = $_POST['to_email'];

        $data = [
            'mail_from_name' => $mail_from_name,
            'mail_from' => $mail_from,
            'mail_to_name' => $mail_to_name,
            'mail_to' => $mail_to,
        ];
        $data['updated_at'] =  date('Y-m-d h:i:s');
        $update_coloum = '';
        $updated_coloms_keys = array_keys($data);
        foreach ($data as $uk => $uv) {
            if ($uk != end($updated_coloms_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
        }

        $sql = "UPDATE " . SETTINGS . " SET " . $update_coloum . " WHERE id = 1";
        $mode = 'Updated';
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {
            $type = 'success';
            $msg = 'Settings Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Settings!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'account/settings');
    }
}
