<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Review List</a></li>
    </ol>
</div>
<!-- row -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Review List</h4>
                <h4><a href="<?= ADMIN_URL . 'property/manage-reviews' ?>" class="btn btn-success">Add Review</a></h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display table" style="min-width: 850px">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Title</th>
                                <th>Star</th>
                                <th>Status</th>
                                <th>Stay Date</th>
                                <th>Added Date</th>
                                <th>Updated Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($reviews_count > 0) { ?>
                                <?php foreach ($reviews_list as $ev) { ?>
                                    <tr>
                                        <td><?= ++$start_counter; ?></td>
                                        <td style="width: 15%;"><?php echo $ev['name']; ?></td>
                                        <td style="width: 15%;"><?php echo $ev['email']; ?></td>
                                        <td style="width: 20%;"><?php echo $ev['title']; ?></td>
                                        <td><?php echo $ev['star']; ?></td>
                                        <td><?php echo ($ev['status'] == 1 ? 'Active' : 'Inactive'); ?></td>
                                        <td><?php echo !empty($ev['staydate']) ? date('d, M Y', strtotime($ev['staydate'])) : ''; ?></td>
                                        <td><?php echo !empty($ev['added_date']) ? date('d, M Y', strtotime($ev['added_date'])) : ''; ?></td>
                                        <td><?php echo !empty($ev['updated_date']) ? date('d, M Y', strtotime($ev['updated_date'])) : ''; ?></td>
                                        <td>
                                            <a href="<?= ADMIN_URL . 'property/manage-reviews/' . encryptData($ev['id']) ?>" class="btn btn-success btn-sm"><i class="fa fa-pencil"></i> Edit</a>
                                            <a href="javascript:void(0);"  onclick="deleteData(this)"  data-href="<?= ADMIN_URL . 'property/delete-reviews/' . encryptData($ev['id']) ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="10" class="text-center">No Records Found</td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <?php if ($reviews_count > 0) { ?>
                    <div class="col-lg-12">
                        <p class="mb-2 me-3">
                            <?= $reviews_pagination->displayLinks(ADMIN_URL . 'property/reviews'); ?>
                        </p>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    function deleteData(_this) {
        let url = $(_this).attr('data-href');
        new swal({
            title: 'Are you sure?',
            text: "It will permanently deleted !",
            type: 'danger',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            } else if (result.isDenied) {}
        })
    }
</script>