<div class="page-header">
    <h3>GET QUOTE</h3>
</div>

<div id="booking-page" class=" text-center">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <h3>
                    <?= $property_data['title'] . ': BOOKING QUOTE' ?>
                </h3>
                <div class="booking_page">
                    <form id="get-quote">
                        <input type="hidden" name="checkin" value="<?= $check_in_field; ?>">
                        <input type="hidden" name="checkout" value="<?= $check_out_field; ?>">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr class="rates-header">
                                        <td>Check In</td>
                                        <td>Check Out</td>
                                        <td>Min Stay</td>
                                        <td>Total Nights</td>
                                        <td>Nightly</td>
                                        <td>Weekly</td>
                                        <td>Gross Amount</td>
                                    </tr>
                                    <tr class="rates-body">
                                        <td><?= $check_in; ?></td>
                                        <td><?= $check_out; ?></td>
                                        <td><?= $days; ?> Nights</td>
                                        <td><?= $days; ?></td>
                                        <td><?= !empty($rates['nightly']) ? '$' . $rates['nightly'] : '-' ?></td>
                                        <td><?= !empty($rates['weekend']) ? '$' . $rates['weekend'] : '-' ?></td>
                                        <td><?= !empty($gross_amount) ? '$' . $gross_amount : '-' ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="6">Tax (<?= $property_data['tax'] ?>.00%)</td>
                                        <td><?= '$' . ($tax) ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="6">Service Tax (<?= $property_data['service_fee'] ?>.00%)</td>
                                        <td><?= '$' . ($service_fees) ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="6">Net Payable Amount</td>
                                        <td><?= '$' . ($final_amount) ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">Full Name</td>
                                        <td colspan="3">
                                            <div class="form-group">
                                                <input class="form-control" type="text" name="fname" value="" required placeholder="Your Name">
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">Email</td>
                                        <td colspan="3">
                                            <div class="form-group">
                                                <input class="form-control" type="email" name="email" value="" required placeholder="Your Email">
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">Phone</td>
                                        <td colspan="3">
                                            <div class="form-group">
                                                <input class="form-control" type="tel" name="phone" value="" required placeholder="Your Mobile Number">
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">Guests</td>
                                        <td colspan="3">
                                            <div class="form-group">
                                                <select name="guest" class="form-control form-select" required>
                                                    <option value="">Select Guest</option>
                                                    <?php foreach (range(1, 12) as $v) { ?>
                                                        <option value="<?= $v; ?>"><?= $v; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">Address</td>
                                        <td colspan="3">
                                            <div class="form-group">
                                                <textarea name="address" class="form-control" required placeholder="Write Message"></textarea>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="7">
                                            <div class="btn-group">
                                                <button type="submit" name="" class="btn btn-success form-control">Submit Enquiry</button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    $(document).on('submit', '#get-quote', function(e) {
        e.preventDefault();
        var form = $(this);
        $.ajax({
            type: "POST",
            url: '<?= SITE_URL . 'rates/send-quote' ?>',
            data: form.serialize(), // serializes the form's elements.
            dataType: 'json',
            success: function(data) {
                if (data['status'] == 'success') {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                }

            }
        });
    });
</script>
</script>