<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */


// Users Routes
//$routes->get('/', 'Users::login');
//$routes->get('/user/registration', 'Users::registration');
//$routes->get('/user/profile', 'Users::profile');

$routes->get('/signup', 'SignupController::index');
$routes->get('/', 'SigninController::index');
$routes->get('/signin', 'SigninController::index');
$routes->get('/manager', 'SigninController::index');
//$routes->get('/forgot-password', 'PasswordResetController::index');
$routes->match(['get', 'post'], '/forgot-password', 'PasswordResetController::index');
$routes->match(['get', 'post'], '/reset-password', 'PasswordResetController::reset');

$routes->match(['get', 'post'], 'SignupController/store', 'SignupController::store');
$routes->match(['get', 'post'], 'SigninController/loginAuth', 'SigninController::loginAuth');
$routes->get('/logout', 'SigninController::logout');


$routes->get('/customer/login', 'SigninController::customerLogin');
$routes->get('/customer/signup', 'SignupController::customerSignup');
$routes->match(['get', 'post'], 'SignupController/saveCustomer', 'SignupController::saveCustomer');

$routes->match(['get', 'post'], 'SigninController/loginCustomer', 'SigninController::loginCustomer');
$routes->get('/customer-dashboard', 'Dashboard::customerDashboard',['filter' => 'authGuard']);


$routes->get('/dashboard', 'Dashboard::index',['filter' => 'authGuard']);

$routes->get('/customers/create', 'Customers::new',['filter' => 'authGuard']);
$routes->get('/customer-profile', 'Customers::viewProfile',['filter' => 'authGuard']);
$routes->get('/customers', 'Customers::index',['filter' => 'authGuard']);
$routes->get('/view-file/(:num)', 'Customers::viewFile/$1',['filter' => 'authGuard']);
$routes->get('/customers/view/(:num)', 'Customers::view/$1',['filter' => 'authGuard']);
$routes->get('/customers/edit/(:num)', 'Customers::edit/$1',['filter' => 'authGuard']);
$routes->get('customers/delete/(:num)', 'Customers::delete/$1',['filter' => 'authGuard']);
$routes->get('/customers/add-file/(:num)', 'Customers::add_file/$1',['filter' => 'authGuard']);

$routes->get('/customers/personal-details', 'Customers::viewPersonalDetails',['filter' => 'authGuard']);
$routes->get('/customers/bank-details', 'Customers::viewBankDetails',['filter' => 'authGuard']);
$routes->get('/customers/documents', 'Customers::viewDocuments',['filter' => 'authGuard']);
$routes->post('/customers/save-personal-details', 'Customers::savePersonalDetails',['filter' => 'authGuard']);
$routes->post('/customers/save-bank-details', 'Customers::saveBankDetails',['filter' => 'authGuard']);
$routes->post('/customers/save-documents', 'Customers::saveDocuments',['filter' => 'authGuard']);

$routes->post('/customers/save', 'Customers::save',['filter' => 'authGuard']);
$routes->post('/customers/update/', 'Customers::update',['filter' => 'authGuard']);
$routes->post('/customers/upload', 'Customers::upload',['filter' => 'authGuard']);


/// AGENT ROUTES

$routes->get('/agent/login', 'SigninController::agentLogin');
$routes->match(['get', 'post'], 'SigninController/doAgentLogin', 'SigninController::doAgentLogin');

$routes->get('/agent/signup', 'SignupController::agentSignup');
$routes->match(['get', 'post'], 'SignupController/registerAgent', 'SignupController::registerAgent');

$routes->get('/agent-dashboard', 'Dashboard::agentDashboard',['filter' => 'authGuard']);

$routes->get('/agent/create-employee', 'Employee::createEmployee',['filter' => 'authGuard']);
$routes->get('/agent/list-employee', 'Employee::EmployeeList',['filter' => 'authGuard']);

$routes->post('/agent/save-employee', 'Employee::saveEmployeeData',['filter' => 'authGuard']);
$routes->post('/agent/update-employee', 'Employee::updateEmployeeData',['filter' => 'authGuard']);

$routes->get('/agent/view-employee/(:num)', 'Employee::viewEmployee/$1',['filter' => 'authGuard']);
$routes->get('/agent/edit-employee/(:num)', 'Employee::editEmployee/$1',['filter' => 'authGuard']);
$routes->get('/agent/delete-employee/(:num)', 'Employee::deleteEmployee/$1',['filter' => 'authGuard']);
$routes->get('/agent/add-employee-file/(:num)', 'Employee::addEmployeeFile/$1',['filter' => 'authGuard']);
$routes->get('/agent/employee-offer-upload/(:num)', 'Employee::saveOfferFile',['filter' => 'authGuard']);
$routes->get('/agent/employee-export/(:num)', 'Employee::exportsData/$1',['filter' => 'authGuard']);

// AGENT router for super admin
$routes->get('/agents-list', 'Agent::index',['filter' => 'authGuard']);
$routes->get('/agent-employee/(:num)', 'Agent::agentEmployeeList/$1',['filter' => 'authGuard']);





