<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\CustomersModel;
use App\Models\AgentModel;
use App\Models\EmployeeModel;

class Dashboard extends BaseController {

    public function index() {
        $data = [
            'name' => $this->session->get('name'),
            'email' => $this->session->get('email')
        ];
        
        $agentModel = model(AgentModel::class);
        $data['agent_list'] = $agentModel->getAgents();
        
        $employeeModel = model(EmployeeModel::class);
        $data['offer'] = $employeeModel->getAllEmployeesHavingOffer();
        
        
        echo view('dashboard', $data);
    }
    
    public function customerDashboard() {
         $data = [
            'id' => $this->session->get('id'),
            'name' => $this->session->get('name'),
            'email' => $this->session->get('email')
        ];
        echo view('customer_dashboard', $data);
    }
    
    public function agentDashboard() {
        $data = [
            'id' => $this->session->get('id'),
            'name' => $this->session->get('name'),
            'email' => $this->session->get('email')
        ];
        
        $model = model(EmployeeModel::class);
        $data['no_of_customers'] = $model->getEmployeesByFieldManagerId($this->session->id);
        $data['no_of_offers'] = $model->getEmployeesHavingOffer($this->session->id);
        echo view('agent_dashboard', $data);
    }
}
