<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\CustomersModel;

class SignupController extends BaseController {

    public function index() {
        $data = [];
        echo view('registration', $data);
    }

    public function store() {
        $rules = [
            'name' => 'required|min_length[2]|max_length[50]',
            'email' => 'required|min_length[4]|max_length[100]|valid_email|is_unique[users.email]',
            'password' => 'required|min_length[4]|max_length[50]',
            'confirmpassword' => 'matches[password]'
        ];

        if ($this->validate($rules)) {
            $userModel = new UserModel();
            $data = [
                'name' => $this->request->getVar('name'),
                'email' => $this->request->getVar('email'),
                'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT)
            ];
            $userModel->save($data);
            return redirect()->to('/signin');
        } else {
            $data['validation'] = $this->validator;
            echo view('signup', $data);
        }
    }

    public function customerSignup() {
        $data = [];
        echo view('customer_singup', $data);
    }

    public function saveCustomer() {
        $rules = [
            'name' => 'required|min_length[2]|max_length[50]',
            'email' => 'required|min_length[4]|max_length[100]|valid_email|is_unique[users.email]',
            'mobile' => 'required|min_length[10]|max_length[50]',
            'password' => 'required|min_length[4]|max_length[50]',
            'confirmpassword' => 'matches[password]'
        ];

        if ($this->validate($rules)) {
            $userModel = new CustomersModel();
            $data = [
                'customer_name' => $this->request->getVar('name'),
                'customer_email' => $this->request->getVar('email'),
                'customer_mobile' => $this->request->getVar('mobile'),
                'customer_password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT)
            ];
            $userModel->save($data);
            $this->session->markAsFlashdata('success');
            $this->session->setFlashdata('success', 'Signup Successfully');

            return redirect()->to('/customer/signup');
        } else {
            $data['validation'] = $this->validator;
            echo view('customer_singup', $data);
        }
    }
    
     public function agentSignup() {
        $data = [];
        echo view('agent_signup', $data);
    }

    public function registerAgent() {
        $rules = [
            'name' => 'required|min_length[2]|max_length[50]',
            'email' => 'required|min_length[4]|max_length[100]|valid_email|is_unique[users.email]',
            'password' => 'required|min_length[4]|max_length[50]',
            'confirmpassword' => 'matches[password]'
        ];

        if ($this->validate($rules)) {
            $userModel = new \App\Models\AgentModel();
            $data = [
                'name' => $this->request->getVar('name'),
                'email' => $this->request->getVar('email'),
                'status' => 1,
                'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT)
            ];
            $userModel->save($data);
            $this->session->markAsFlashdata('success');
            $this->session->setFlashdata('success', 'Agent Signup Successfully');
            return redirect()->to('/agent/login');
        } else {
            $data['validation'] = $this->validator;
            echo view('agent_signup', $data);
        }
    }
}
