<?php

namespace App\Models;

use CodeIgniter\Model;

class CustomersModel extends Model {

    protected $table = 'customers';
    
    protected $allowedFields = [
        'customer_name',
        'customer_email',
        'customer_mobile',
        'customer_password',
        'customer_file',
        'password_reset_otp',
        'password_reset_at',
        'created_at'
        ];

    /**
     * @param false|string $id
     *
     * @return array|null
     */
    public function getCustomers($id = false) {
        if ($id === false) {
            return $this->findAll();
        }

        return $this->where(['id' => $id])->first();
    }
    
    public function getCustomersHavingOffer() {

      return $this->where('customer_file !=', "")->findAll();

    }
    
}
