<?php

namespace App\Models;

use CodeIgniter\Model;

class DocumentsModel extends Model {

    protected $table = 'documents';
    protected $allowedFields = [
        'customer_id',
        'person_photo',
        'aadhar_card',
        'pancard',
        'passbook_cheque',
        'reference_aaddhar_photo_1',
        'reference_aaddhar_photo_2',
        'education_certificate',
        'created_at',
        'updated_at'
    ];
    protected $useTimestamps = true;

    /**
     * @param false|string $id
     *
     * @return array|null
     */
    public function getDocuments($id = false) {
        if ($id === false) {
            return $this->findAll();
        }

        return $this->where(['customer_id' => $id])->first();
    }
    
    public function getDocumentsByID($id = false) {
        if ($id === false) {
            return $this->findAll();
        }

        return $this->where(['id' => $id])->first();
    }
}
