<?php

namespace App\Models;

use CodeIgniter\Model;

class EmployeeModel extends Model
{

  protected $table = 'employee';
  protected $allowedFields = [
      'field_manager_id',
      'organization',
      'person_name',
      'gender',
      'marital_status',
      'spouse_name',
      'person_dob',
      'mother_name',
      'father_name',
      'education',
      'experience',
      'height',
      'local_address',
      'permanent_address',
      'state',
      'city',
      'pincode',
      'contact_no',
      'ref_no_1',
      'ref_no_2',
      'esic_no',
      'pf_no',
      'bank_name',
      'bank_account_no',
      'bank_ifsc_code',
      'bank_branch_name',
      'doc_person_photo',
      'doc_aadhar_card',
      'doc_pancard',
      'doc_passbook_cheque',
      'doc_reference_aaddhar_photo_1',
      'doc_reference_aaddhar_photo_2',
      'doc_education_certificate',
      'offer_letter',
      'created_at',
      'updated_at'
  ];
  protected $useTimestamps = true;

  /**
   * @param false|string $id
   *
   * @return array|null
   */
  public function getEmployeeDetails($id = false)
  {
    return $this->where(['id' => $id])->first();
  }

  public function getEmployeesByFieldManagerId($id = false)
  {
    return $this->where(['field_manager_id' => $id])->findAll();
  }

  public function getEmployeesHavingOffer($id)
  {

    return $this->where(['field_manager_id' => $id, 'offer_letter !=' => ""])->findAll();
  }
  
    public function getAllEmployeesHavingOffer()
  {

    return $this->where(['offer_letter !=' => ""])->findAll();
  }
}
