<?php

namespace App\Models;

use CodeIgniter\Model;

class PersonalDetailsModel extends Model {

    protected $table = 'personal_details';
    protected $allowedFields = [
        'customer_id',
        'person_name',
        'gender',
        'marital_status',
        'spouse_name',
        'person_dob',
        'mother_name',
        'father_name',
        'education',
        'experience',
        'height',
        'local_address',
        'permanent_address',
        'contact_no',
        'created_at',
        'updated_at'
    ];

    /**
     * @param false|string $id
     *
     * @return array|null
     */
    public function getPersonalDetails($id = false) {
        if ($id === false) {
            return $this->findAll();
        }
        $result = $this->where(['customer_id' => $id])->first();
        return $result;
    }
}
