<!DOCTYPE html>
<html lang="zxx">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Agent || Login Minimal</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/vendors/css/vendors.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
                            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
                            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
                    <![endif]-->
    </head>

    <body>
        <!--! ================================================================ !-->
        <!--! [Start] Main Content !-->
        <!--! ================================================================ !-->
        <main class="auth-minimal-wrapper">
            <div class="auth-minimal-inner">
                <div class="minimal-card-wrapper">
                    <div class="card mb-4 mt-5 mx-4 mx-sm-0 position-relative">
                        <div class="wd-50 bg-white p-2 rounded-circle shadow-lg position-absolute translate-middle top-0 start-50">
                            <img src="<?= base_url(); ?>assets/images/sitelogo/isone.png" alt="" class="img-fluid">
                        </div>
                        <div class="card-body p-sm-5">
                            <h2 class="text-center fs-20 fw-bolder "><a href="/agent/logi">Agent Login</a></h2>
                                <h4 class="text-center fs-13 fw-bold">Or</h4>
                            <h2 class="text-center fs-16 fw-bolder "><a href="/">Click here for Owner Login</a></h2>
                                
                            <!--<h4 class="fs-13 fw-bold mb-2">Login to your Agent account</h4>-->
                            <!--<p class="fs-12 fw-medium text-muted">Thank you for get back <strong>Nelel</strong> web applications, let's access our the best recommendation for you.</p>-->
                            <?php if (session()->getFlashdata('msg')): ?>
                                <div class="alert alert-warning">
                                    <?= session()->getFlashdata('msg') ?>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo base_url(); ?>/SigninController/doAgentLogin" method="post" class="w-100 mt-4 pt-2">
                                <?= csrf_field() ?>
                                <div class="mb-4">
                                    <input type="email" name="email"  class="form-control" placeholder="Email or Username" value="<?= set_value('email') ?>"  required>
                                </div>
                                <div class="mb-3">
                                    <input type="password" name="password" class="form-control" placeholder="Password" required>
                                </div>
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="rememberMe">
                                            <label class="custom-control-label c-pointer" for="rememberMe">Remember Me</label>
                                        </div>
                                    </div>
                                    <div>
                                        <a href="<?php echo base_url(); ?>forgot-password" class="fs-11 text-primary">Forget password?</a>
                                    </div>
                                </div>
                                <div class="mt-5">
                                    <button type="submit" class="btn btn-lg btn-primary w-100">Login</button>
                                </div>
                            </form>
                            <div class="mt-5 text-muted">
                                <span> Don't have an account?</span>
                                <a href="<?php echo base_url(); ?>agent/signup" class="fw-bold">Create an Account</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        <!--! ================================================================ !-->
        <!--! [End] Main Content !-->
        <!--! ================================================================ !-->
        <!--! Footer Script !-->
        <!--! ================================================================ !-->
        <!--! BEGIN: Vendors JS !-->
        <script src="<?= base_url(); ?>public/assets/vendors/js/vendors.min.js"></script>
        <!-- vendors.min.js {always must need to be top} -->
        <!--! END: Vendors JS !-->
        <!--! BEGIN: Apps Init  !-->
        <script src="<?= base_url(); ?>public/assets/js/common-init.min.js"></script>
        <!--! END: Apps Init !-->
        <!--! BEGIN: Theme Customizer  !-->
        <script src="<?= base_url(); ?>public/assets/js/theme-customizer-init.min.js"></script>
        <!--! END: Theme Customizer !-->
    </body>

</html>