<!DOCTYPE html>
<html lang="zxx">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Login Minimal</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/vendors/css/vendors.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>public/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
                            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
                            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
                    <![endif]-->
    </head>

    <body>
        <!--! ================================================================ !-->
        <!--! [Start] Main Content !-->
        <!--! ================================================================ !-->
        <main class="auth-minimal-wrapper">
            <div class="auth-minimal-inner">
                <div class="minimal-card-wrapper">
                    <div class="card mb-4 mt-5 mx-4 mx-sm-0 position-relative">
                        <div class="wd-50 bg-white p-2 rounded-circle shadow-lg position-absolute translate-middle top-0 start-50">
                            <img src="<?= base_url() ?>assets/images/logo-presecure.png" alt="" class="img-fluid">
                        </div>
                        <div class="card-body p-sm-5">
                            <h2 class="text-center fs-20 fw-bolder mb-4">Enployee Register</h2>
                            <p class="fs-12 fw-medium text-muted">Let's get you all setup, so you can verify your personal account and begine setting up your profile.</p>
                            <?php if (isset($_SESSION['success'])) : ?>
                                <div class="alert alert-success">
                                    <?= session('success'); ?>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($validation)): ?>
                                <div class="alert alert-warning">
                                    <?= $validation->listErrors() ?>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo base_url(); ?>SignupController/saveCustomer" method="post">
                                <?= csrf_field() ?>
                                <div class="form-group mb-3">
                                    <input type="text" name="name" placeholder="Name" value="<?= set_value('name') ?>" class="form-control" >
                                </div>
                                <div class="form-group mb-3">
                                    <input type="email" name="email" placeholder="Email" value="<?= set_value('email') ?>" class="form-control" >
                                </div>
                                <div class="form-group mb-3">
                                    <input type="number" name="mobile" placeholder="Mobile" value="<?= set_value('mobile') ?>" class="form-control" >
                                </div>
                                <div class="form-group mb-3">
                                    <input type="password" name="password" placeholder="Password" class="form-control" >
                                </div>
                                <div class="form-group mb-3">
                                    <input type="password" name="confirmpassword" placeholder="Confirm Password" class="form-control" >
                                </div>
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-dark">Submit</button>
                                </div>
                            </form>
                            <div class="mt-5 text-muted">
                                <span>Already have an account?</span>
                                <a href="<?php echo base_url(); ?>customer/login" class="fw-bold">Login</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        <!--! ================================================================ !-->
        <!--! [End] Main Content !-->
        <!--! ================================================================ !-->
        <!--! Footer Script !-->
        <!--! ================================================================ !-->
        <!--! BEGIN: Vendors JS !-->
        <script src="<?= base_url(); ?>public/assets/vendors/js/vendors.min.js"></script>
        <!-- vendors.min.js {always must need to be top} -->
        <!--! END: Vendors JS !-->
        <!--! BEGIN: Apps Init  !-->
        <script src="<?= base_url(); ?>public/assets/js/common-init.min.js"></script>
        <!--! END: Apps Init !-->
        <!--! BEGIN: Theme Customizer  !-->
        <script src="<?= base_url(); ?>public/assets/js/theme-customizer-init.min.js"></script>
        <!--! END: Theme Customizer !-->
    </body>

</html>