<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Employee Documents</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/datepicker.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar_customer') ?>
        <!-- [ Main Content ] start -->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() . 'customer-dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Documents</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card border-top-0">
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="profileTab" role="tabpanel">
                                        <div class="card-body personal-info">
                                            <?php if (session()->getFlashdata('success') != null) { ?>
                                                <div class="alert alert-success">
                                                    <?= session()->getFlashdata('success') ?>
                                                </div>
                                            <?php }
                                            ?>
                                            <?php
                                            $errors = validation_errors();
                                            if (!empty($errors)):
                                                ?>
                                                <div class="alert alert-danger" role="alert">
                                                    <?php foreach ($errors as $error): ?>
                                                        <p><?= esc($error) ?></p>
                                                    <?php endforeach ?>
                                                </div>
                                            <?php endif ?>
                                            <form action="<?php echo base_url(); ?>customers/save-documents" method="post" enctype="multipart/form-data">
                                                <?= csrf_field() ?>
                                                <input type="hidden" name="id" value="<?= $customer['id']; ?>">
                                                <input type="hidden" name="update_id" value="<?= !isset($doc['id']) ? 0 : $doc['id']; ?>">
                                                <div class="row mb-4 align-items-center">
                                                    <h2>Upload Documents <br />

                                                    </h2>
                                                    <div class="alert alert-danger">
                                                        <p>Please Note: </p>
                                                        <ol>
                                                            <li>Documents must in mentioned format: jpg, jpeg, gif, png, webp</li>
                                                            <li>Size of document must be less than 2mb</li>
                                                            <li>Dimension of images must be 1024x768 px</li>
                                                        </ol>
                                                    </div>

                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="person_photo" class="fw-semibold">Person Photo: </label>
                                                    </div>
                                                    <?php $filePath = base_url() . '/public/uploads/' ?>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="file" name="person_photo" class="form-control" id="person_photo" />
                                                        </div>
                                                        <?= isset($doc['person_photo']) ? '<img width="150" height="150" src="' . $filePath . $doc['person_photo'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="aadhar_card" class="fw-semibold">Aadhar card photo: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="file" name="aadhar_card" class="form-control" id="aadhar_card" >
                                                        </div>
                                                        <?= isset($doc['aadhar_card']) ? '<img width="150" height="150" src="' . $filePath . $doc['aadhar_card'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="pancard" class="fw-semibold">Pancard photo: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="file" name="pancard" class="form-control" id="pancard" >
                                                        </div>
                                                        <?= isset($doc['pancard']) ? '<img width="150" height="150" src="' . $filePath . $doc['pancard'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="passbook_cheque" class="fw-semibold">Pass book/ cheque photo: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="file" name="passbook_cheque" class="form-control" id="passbook_cheque" >
                                                        </div>
                                                        <?= isset($doc['passbook_cheque']) ? '<img width="150" height="150" src="' . $filePath . $doc['passbook_cheque'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="reference_aadhar_photo_1" class="fw-semibold">2 reference Aadhaar photo: </label>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group">
                                                            <input type="file" name="reference_aadhar_photo_1" class="form-control" id="reference_aadhar_photo_1" >
                                                        </div>
                                                        <?= isset($doc['reference_aaddhar_photo_1']) ? '<img width="150" height="150" src="' . $filePath . $doc['reference_aaddhar_photo_1'] . '" />' : "" ?>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group">
                                                            <input type="file" name="reference_aadhar_photo_2" class="form-control" id="reference_aadhar_photo_2" >
                                                        </div>
                                                        <?= isset($doc['reference_aaddhar_photo_2']) ? '<img width="150" height="150" src="' . $filePath . $doc['reference_aaddhar_photo_2'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="education_certificate" class="fw-semibold">Education certificate photo: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="file" name="education_certificate" class="form-control" id="education_certificate" >
                                                        </div>
                                                        <?= isset($doc['education_certificate']) ? '<img width="150" height="150" src="' . $filePath . $doc['education_certificate'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="Input" class="fw-semibold"></label>
                                                    </div>
                                                    <div class="col-lg-1 ">
                                                        <input class="btn btn-primary text-dark w-100" type="submit" name="submit" value="<?= isset($doc['id']) ? "Update" : "Save" ?> ">
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- [ Main Content ] end -->
        <?= $this->include('layouts/footer') ?>