<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Personal Details</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/datepicker.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar_customer') ?>
        <!-- [ Main Content ] start -->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() . 'customer-dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Personal Details</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card border-top-0">
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="profileTab" role="tabpanel">
                                        <div class="card-body personal-info">
                                            <?php if (session()->getFlashdata('success') != null) { ?>
                                                <div class="alert alert-success">
                                                    <?= session()->getFlashdata('success') ?>
                                                </div>
                                            <?php }
                                            ?>
                                            <?php
                                            $errors = validation_errors();
                                            if (!empty($errors)):
                                                ?>
                                                <div class="alert alert-danger" role="alert">
                                                    <?php foreach ($errors as $error): ?>
                                                        <p><?= esc($error) ?></p>
                                                    <?php endforeach ?>
                                                </div>
                                            <?php endif ?>
                                            <form action="<?php echo base_url(); ?>customers/save-personal-details" method="post" >
                                                <?= csrf_field() ?>
                                                <input type="hidden" name="id" value="<?= $customer['id']; ?>">
                                                <input type="hidden" name="update_id" value="<?= !isset($personal['id']) ? 0 : $personal['id']; ?>">
                                                <div class="row mb-4 align-items-center">
                                                    <h2>Personal Details</h2>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="organization" class="fw-semibold">Organization Name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="organization" value="<?= !isset($personal['organization']) ? set_value("organization") : $personal['organization'] ?>" class="form-control" id="organization">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="person_name" class="fw-semibold">Person Name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="person_name" value="<?= !isset($personal['person_name']) ? set_value("person_name") : $personal['person_name'] ?>" class="form-control" id="person_name">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="gender" class="fw-semibold">Person Gender: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <?php
                                                            $gender = $personal['gender'] ?? "";
                                                            ?>
                                                            <select class="form-control" id="gender" name="gender">
                                                                <option <?= $gender == 'Male' ? 'selected="selected"' : '' ?> value="Male">Male</option>
                                                                <option <?= $gender == 'Female' ? 'selected="selected"' : '' ?>  value="Female">Female</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="person_dob" class="fw-semibold">DOB: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="person_dob" value="<?= !isset($personal['person_dob']) ? set_value("person_dob") : $personal['person_dob'] ?>" class="form-control" id="person_dob">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="mother_name" class="fw-semibold">Mother name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="mother_name" value="<?= !isset($personal['mother_name']) ? set_value("mother_name") : $personal['mother_name'] ?>" class="form-control" id="mother_name">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="father_name" class="fw-semibold">Father name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="father_name" value="<?= !isset($personal['father_name']) ? set_value("father_name") : $personal['father_name'] ?>" class="form-control" id="father_name" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="father_name" class="fw-semibold">Marital Status: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <?php
                                                            $marital_status = $personal['marital_status'] ?? "";
                                                            ?>
                                                            <select class="form-control" id="marital_status" name="marital_status">
                                                                <option <?= $marital_status == "Unmarried" ? 'selected="selected"' : '' ?> value="Unmarried">Unmarried</option>
                                                                <option <?= $marital_status == "Married" ? 'selected="selected"' : '' ?> value="Married">Married</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center" style="display: none" id="spouse_name_div">
                                                    <div class="col-lg-4">
                                                        <label for="spouse_name" class="fw-semibold">Spouse Name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="spouse_name" value="<?= !isset($personal['spouse_name']) ? set_value("spouse_name") : $personal['spouse_name'] ?>" class="form-control" id="spouse_name" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="education" class="fw-semibold">Education: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="education" value="<?= !isset($personal['education']) ? set_value("education") : $personal['education'] ?>" class="form-control" id="education" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="experience" class="fw-semibold">Experience: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="experience" value="<?= !isset($personal['experience']) ? set_value("experience") : $personal['experience'] ?>" class="form-control" id="experience">
                                                            <select class="form-control" name="experience_type">
                                                                <option value="Years">Years</option>
                                                                <option value="Months">Months</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="height" class="fw-semibold">Height: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="height" value="<?= !isset($personal['height']) ? set_value("height") : $personal['height'] ?>" class="form-control" id="height">
                                                            <select class="form-control" name="height_type">
                                                                <option value="Feet">Feet</option>
                                                                <option value="CM">CM</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="local_address" class="fw-semibold">Local Address: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="local_address" value="<?= !isset($personal['local_address']) ? set_value("local_address") : $personal['local_address'] ?>" class="form-control" id="local_address" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="permanent_address" class="fw-semibold">Permanent Address: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="permanent_address" value="<?= !isset($personal['permanent_address']) ? set_value("permanent_address") : $personal['permanent_address'] ?>" class="form-control" id="permanent_address">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="state" class="fw-semibold">State: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="state" value="<?= !isset($personal['state']) ? set_value("state") : $personal['state'] ?>" class="form-control" id="state">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="city" class="fw-semibold">City: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="city" value="<?= !isset($personal['city']) ? set_value("city") : $personal['city'] ?>" class="form-control" id="city">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="pincode" class="fw-semibold">Pincode: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="pincode" value="<?= !isset($personal['pincode']) ? set_value("pincode") : $personal['pincode'] ?>" class="form-control" id="pincode">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="contact_no" class="fw-semibold">Contact No: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">

                                                            <input type="text" name="contact_no" value="<?= !isset($personal['contact_no']) ? set_value("contact_no") : $personal['contact_no'] ?>" class="form-control" id="contact_no">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="ref_no_1" class="fw-semibold">2 Reference No: </label>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group">
                                                            <input placeholder="Ref No 1" type="text" name="ref_no_1" value="<?= !isset($personal['ref_no_1']) ? set_value("ref_no_1") : $personal['ref_no_1'] ?>" class="form-control" id="ref_no_1">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group">
                                                            <input placeholder="Ref No 2" type="text" name="ref_no_2" value="<?= !isset($personal['ref_no_2']) ? set_value("ref_no_2") : $personal['ref_no_2'] ?>" class="form-control" id="ref_no_2">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="esic_no" class="fw-semibold">ESIC No: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="esic_no" value="<?= !isset($personal['esic_no']) ? set_value("esic_no") : $personal['esic_no'] ?>" class="form-control" id="esic_no">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="pf_no" class="fw-semibold">PF No: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="pf_no" value="<?= !isset($personal['pf_no']) ? set_value("pf_no") : $personal['pf_no'] ?>" class="form-control" id="pf_no">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="Input" class="fw-semibold"></label>
                                                    </div>
                                                    <div class="col-lg-1 ">
                                                        <input class="btn btn-primary text-dark w-100" type="submit" name="submit" value="<?= isset($personal['id']) ? "Update" : "Save" ?>">
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- [ Main Content ] end -->
        <?= $this->include('layouts/footer') ?>
        <script>
            $(document).ready(function () {
                $('#marital_status').on('change', function () {
                    let marital_status = $(this).val();
                    console.log(marital_status)
                    if (marital_status == "Married") {
                        $('#spouse_name_div').show();
                    } else {
                        $('#spouse_name_div').hide();
                    }
                });
            });
        </script>