<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Employee Create</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/datepicker.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar') ?>
        <!-- [ Main Content ] start -->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() . '/dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Employee Details</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-xxl-12 col-xl-12">
                            <div class="card border-top-0">
                                <div class="card-header p-0">
                                    <!-- Nav tabs -->
                                    <ul class="nav nav-tabs flex-wrap w-100 text-center customers-nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item flex-fill border-top" role="presentation">
                                            <a href="javascript:void(0);" class="nav-link active" data-bs-toggle="tab" data-bs-target="#overviewTab" role="tab">Personal Information</a>
                                        </li>
                                        <li class="nav-item flex-fill border-top" role="presentation">
                                            <a href="javascript:void(0);" class="nav-link" data-bs-toggle="tab" data-bs-target="#billingTab" role="tab">Bank Details</a>
                                        </li>
                                        <li class="nav-item flex-fill border-top" role="presentation">
                                            <a href="javascript:void(0);" class="nav-link" data-bs-toggle="tab" data-bs-target="#activityTab" role="tab">Documents</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active p-4" id="overviewTab" role="tabpanel">
                                        <div class="profile-details mb-5">
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Person Name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['person_name'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Person Gender:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['gender'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Marital Status:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['marital_status'] ?? "" ?></div>
                                            </div>
                                            <?php if($personal_details['marital_status'] == "Married")  { ?>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Spouse Name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['spouse_name'] ?? "" ?></div>
                                            </div>
                                              <?php } ?>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Date of Birth:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['person_dob'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Mother name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['mother_name'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Father name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['father_name'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Education:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['education'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Experience:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['experience'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Height:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['height'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Local Address:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['local_address'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Permanent Address:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['permanent_address'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Contact No:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['contact_no'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Ref No 1:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['ref_no_1'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Ref No 2:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['ref_no_2'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">ESIC No:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['esic_no'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">PF No:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $personal_details['pf_no'] ?? "" ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade p-4" id="billingTab" role="tabpanel">
                                        <div class="profile-details mb-5">
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Bank name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $bank_details['bank_name'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Bank Account:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $bank_details['account_no'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">IFSC code:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $bank_details['ifsc_code'] ?? "" ?></div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Branch name:</div>
                                                <div class="col-sm-6 fw-semibold"><?= $bank_details['branch_name'] ?? "" ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade p-4" id="activityTab" role="tabpanel">
                                        <?php $filePath = base_url() . '/public/uploads/' ?>
                                        <div class="profile-details mb-5">
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Person Photo:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['person_photo']) ? '<img width="150" height="150" src="' . $filePath . $document['person_photo'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['person_photo'])) {
                                                        echo '<a href="' . $filePath . $document['person_photo'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Aadhar card photo:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['aadhar_card']) ? '<img width="150" height="150" src="' . $filePath . $document['aadhar_card'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['aadhar_card'])) {
                                                        echo '<a href="' . $filePath . $document['aadhar_card'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Pancard photo:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['pancard']) ? '<img width="150" height="150" src="' . $filePath . $document['pancard'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['pancard'])) {
                                                        echo '<a href="' . $filePath . $document['pancard'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Pass book/ cheque photo: </div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['passbook_cheque']) ? '<img width="150" height="150" src="' . $filePath . $document['passbook_cheque'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['passbook_cheque'])) {
                                                        echo '<a href="' . $filePath . $document['passbook_cheque'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">reference Aadhaar photo 1:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['reference_aaddhar_photo_1']) ? '<img width="150" height="150" src="' . $filePath . $document['reference_aaddhar_photo_1'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['reference_aaddhar_photo_1'])) {
                                                        echo '<a href="' . $filePath . $document['reference_aaddhar_photo_1'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">reference Aadhaar photo 2:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['reference_aaddhar_photo_2']) ? '<img width="150" height="150" src="' . $filePath . $document['reference_aaddhar_photo_2'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['reference_aaddhar_photo_2'])) {
                                                        echo '<a href="' . $filePath . $document['reference_aaddhar_photo_2'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="row g-0 mb-4">
                                                <div class="col-sm-6 text-muted">Education certificate photo:</div>
                                                <div class="col-sm-6 fw-semibold">
                                                    <?= isset($document['education_certificate']) ? '<img width="150" height="150" src="' . $filePath . $document['education_certificate'] . '" />' : "" ?>
                                                    <?php
                                                    if (!empty($document['education_certificate'])) {
                                                        echo '<a href="' . $filePath . $document['education_certificate'] . '">Download</a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- [ Main Content ] end -->
        <?= $this->include('layouts/footer') ?>