<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Employee Edit</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/datepicker.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/custom-style.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">

        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar_agent') ?>
        <!-- [ Main Content ] start -->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() . '/employee-dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Employee Details</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-xxl-12 col-xl-12">
                            <div class="card border-top-0">
                                <div class="card-body personal-info">
                                    <?php if (session()->getFlashdata('success') != null) { ?>
                                        <div class="alert alert-success">
                                            <?= session()->getFlashdata('success') ?>
                                        </div>
                                        <?php
                                    }
                                    $errors = isset($validation) ? $validation->getErrors() : [];
                                    ?>
                                    <form action="<?php echo base_url(); ?>agent/update-employee" method="post" enctype="multipart/form-data" >
                                        <div class="profile-details mb-2">
                                            <h3>Update Employee</h3>
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="update_id" value="<?= $employee['id'] ?>">
                                            <div class="row mb-4 align-items-center">
                                                <h4>Personal Details</h4>
                                                <p class="red">(*)All fields are required.</p>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="organization" class="fw-semibold form-label">Organization Name<span class="text-danger">(*)</span>: </label>
                                                        <input type="text" name="organization" value="<?= !isset($employee['organization']) ? set_value("organization") : $employee['organization'] ?>" class="form-control" id="organization">
                                                        <?= isset($errors['organization']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['organization'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="person_name" class="form-label">Person Name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="person_name" value="<?= !isset($employee['person_name']) ? set_value("person_name") : $employee['person_name'] ?>" class="form-control" id="person_name">
                                                        <?= isset($errors['person_name']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['person_name'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="gender" class="fw-semibold form-label">Person Gender<span class="red">(*)</span>: </label>
                                                        <?php
                                                        $gender = $employee['gender'] ?? "";
                                                        ?>
                                                        <select class="form-control" id="gender" name="gender">
                                                            <option <?= $gender == 'Male' ? 'selected="selected"' : '' ?> value="Male">Male</option>
                                                            <option <?= $gender == 'Female' ? 'selected="selected"' : '' ?>  value="Female">Female</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="person_dob" class="fw-semibold form-label">Select DOB<span class="red">(*)</span>: </label>
                                                        <input type="text" name="person_dob" value="<?= !isset($employee['person_dob']) ? set_value("person_dob") : $employee['person_dob'] ?>" class="form-control" id="person_dob">
                                                        <?= isset($errors['person_dob']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['person_dob'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="mother_name" class="form-label">Mother Name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="mother_name" value="<?= !isset($employee['mother_name']) ? set_value("mother_name") : $employee['mother_name'] ?>" class="form-control" id="person_name">
                                                        <?= isset($errors['mother_name']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['mother_name'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="father_name" class="form-label">Father Name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="father_name" value="<?= !isset($employee['father_name']) ? set_value("father_name") : $employee['father_name'] ?>" class="form-control" id="person_name">
                                                        <?= isset($errors['father_name']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['father_name'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="father_name" class="fw-semibold">Marital Status<span class="red">(*)</span>: </label>
                                                        <?php
                                                        $marital_status = $employee['marital_status'] ?? "";
                                                        ?>
                                                        <select class="form-control" id="marital_status" name="marital_status">
                                                            <option <?= $marital_status == "Unmarried" ? 'selected="selected"' : '' ?> value="Unmarried">Unmarried</option>
                                                            <option <?= $marital_status == "Married" ? 'selected="selected"' : '' ?> value="Married">Married</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4" style="display: none" id="spouse_name_div">
                                                    <div class="mb-3">
                                                        <label for="spouse_name" class="fw-semibold form-label">Spouse Name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="spouse_name" value="<?= !isset($employee['spouse_name']) ? set_value("spouse_name") : $employee['spouse_name'] ?>" class="form-control" id="spouse_name" >
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="education" class="form-label">Education<span class="red">(*)</span>: </label>
                                                        <input type="text" name="education" value="<?= !isset($employee['education']) ? set_value("education") : $employee['education'] ?>" class="form-control" id="person_name">
                                                        <?= isset($errors['education']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['education'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="experience" class="fw-semibold">Experience<span class="red">(*)</span>: </label>
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                                <input type="text" name="experience" value="<?= !isset($employee['experience']) ? set_value("experience") : $employee['experience'] ?>" class="form-control" id="experience">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <select class="form-control" name="experience_type">
                                                                    <option value="Years">Years</option>
                                                                    <option value="Months">Months</option>
                                                                </select>
                                                            </div>
                                                            <?= isset($errors['experience']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['experience'] . '</div>' : ""; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="height" class="fw-semibold">Height<span class="red">(*)</span>: </label>
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                                <input type="text" name="height" value="<?= !isset($employee['height']) ? set_value("height") : $employee['height'] ?>" class="form-control" id="height">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <select class="form-control" name="height_type">
                                                                    <option value="CM">CM</option>
                                                                    <option value="Feet">Feet</option>
                                                                </select>
                                                            </div>
                                                            <?= isset($errors['height']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['height'] . '</div>' : ""; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="local_address" class="fw-semibold form-label">Local Address<span class="red">(*)</span>: </label>
                                                        <input type="text" name="local_address" value="<?= !isset($employee['local_address']) ? set_value("local_address") : $employee['local_address'] ?>" class="form-control" id="local_address" >
                                                        <?= isset($errors['local_address']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['local_address'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="permanent_address" class="fw-semibold form-label">Permanent Address<span class="red">(*)</span>: </label>
                                                        <input type="text" name="permanent_address" value="<?= !isset($employee['permanent_address']) ? set_value("permanent_address") : $employee['permanent_address'] ?>" class="form-control" id="permanent_address">
                                                        <?= isset($errors['permanent_address']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['permanent_address'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="state" class="fw-semibold form-label">State<span class="red">(*)</span>: </label>
                                                        <input type="text" name="state" value="<?= !isset($employee['state']) ? set_value("state") : $employee['state'] ?>" class="form-control" id="state">
                                                        <?= isset($errors['state']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['state'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="city" class="fw-semibold form-label">City<span class="red">(*)</span>: </label>
                                                        <input type="text" name="city" value="<?= !isset($employee['city']) ? set_value("city") : $employee['city'] ?>" class="form-control" id="city">
                                                        <?= isset($errors['city']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['city'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="pincode" class="fw-semibold form-label">Pincode<span class="red">(*)</span>: </label>
                                                        <input type="text" name="pincode" value="<?= !isset($employee['pincode']) ? set_value("pincode") : $employee['pincode'] ?>" class="form-control" id="pincode">
                                                        <?= isset($errors['pincode']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['pincode'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="contact_no" class="fw-semibold form-label">Contact No<span class="red">(*)</span>: </label>
                                                        <input type="text" name="contact_no" value="<?= !isset($employee['contact_no']) ? set_value("contact_no") : $employee['contact_no'] ?>" class="form-control" id="contact_no">
                                                        <?= isset($errors['contact_no']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['contact_no'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="esic_no" class="fw-semibold form-label">ESIC No<span class="red">(*)</span>: </label>
                                                        <input type="text" name="esic_no" value="<?= !isset($employee['esic_no']) ? set_value("esic_no") : $employee['esic_no'] ?>" class="form-control" id="esic_no">
                                                        <?= isset($errors['esic_no']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['esic_no'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="pf_no" class="fw-semibold">PF No<span class="red">(*)</span>: </label>
                                                            <input type="text" name="pf_no" value="<?= !isset($employee['pf_no']) ? set_value("pf_no") : $employee['pf_no'] ?>" class="form-control" id="pf_no">
                                                            <?= isset($errors['pf_no']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['pf_no'] . '</div>' : ""; ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="ref_no_1" class="fw-semibold">Reference No 1<span class="red">(*)</span>: </label>
                                                            <input type="text" name="ref_no_1" value="<?= !isset($employee['ref_no_1']) ? set_value("ref_no_1") : $employee['ref_no_1'] ?>" class="form-control" id="ref_no_1">
                                                            <?= isset($errors['ref_no_1']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['ref_no_1'] . '</div>' : ""; ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="ref_no_2" class="fw-semibold">Reference No 2<span class="red">(*)</span>: </label>
                                                            <input type="text" name="ref_no_2" value="<?= !isset($employee['ref_no_2']) ? set_value("ref_no_2") : $employee['ref_no_2'] ?>" class="form-control" id="ref_no_2">
                                                            <?= isset($errors['ref_no_2']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['ref_no_2'] . '</div>' : ""; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <h3>Bank Details</h3>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="bank_name" class="fw-semibold">Bank name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="bank_name" value="<?= !isset($employee['bank_name']) ? set_value("bank_name") : $employee['bank_name'] ?>" class="form-control" id="bank_name">
                                                        <?= isset($errors['bank_name']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['bank_name'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="account_no" class="fw-semibold">Account no<span class="red">(*)</span>: </label>
                                                        <input type="number" name="account_no" value="<?= !isset($employee['bank_account_no']) ? set_value("bank_account_no") : $employee['bank_account_no'] ?>" class="form-control" id="account_no">
                                                        <?= isset($errors['account_no']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['account_no'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="ifsc_code" class="fw-semibold">IFSC code<span class="red">(*)</span>: </label>
                                                        <input type="text" name="ifsc_code" value="<?= !isset($employee['bank_ifsc_code']) ? set_value("ifsc_code") : $employee['bank_ifsc_code'] ?>" class="form-control" id="ifsc_code">
                                                        <?= isset($errors['ifsc_code']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['ifsc_code'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="branch_name" class="fw-semibold">Branch name<span class="red">(*)</span>: </label>
                                                        <input type="text" name="branch_name" value="<?= !isset($employee['bank_branch_name']) ? set_value("branch_name") : $employee['bank_branch_name'] ?>" class="form-control" id="branch_name">
                                                        <?= isset($errors['branch_name']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['branch_name'] . '</div>' : ""; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <h3>Documents</h3>
                                            <div class="row">
                                                <div class="alert alert-danger">
                                                    <p>Please Note: </p>
                                                    <ol>
                                                        <li>Documents must in mentioned format: jpg, jpeg, gif, png, webp</li>
                                                        <li>Size of document must be less than 2mb</li>
                                                        <li>Dimension of images must be 1024x768 px</li>
                                                    </ol>
                                                </div>
                                            </div>
                                            <?php $filePath = base_url() . '/public/uploads/' ?>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="person_photo" class="fw-semibold">Person Photo<span class="red">(*)</span>: </label>
                                                        <input type="file" name="person_photo" class="form-control" id="person_photo" />
                                                        <?= isset($errors['person_photo']) ? '<div class="alert alert-danger mt-1" role="alert">' . $errors['person_photo'] . '</div>' : ""; ?>
                                                        <?= isset($employee['doc_person_photo']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_person_photo'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="aadhar_card" class="fw-semibold">Aadhar card photo<span class="red">(*)</span>: </label>
                                                        <input type="file" name="aadhar_card" class="form-control" id="aadhar_card" >
                                                        <?= isset($employee['doc_aadhar_card']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_aadhar_card'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="pancard" class="fw-semibold">Pancard photo<span class="red">(*)</span>: </label>
                                                        <input type="file" name="pancard" class="form-control" id="pancard" >
                                                        <?= isset($employee['doc_pancard']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_pancard'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="passbook_cheque" class="fw-semibold">Pass book/ cheque photo<span class="red">(*)</span>: </label>
                                                        <input type="file" name="passbook_cheque" class="form-control" id="passbook_cheque" >
                                                        <?= isset($employee['doc_passbook_cheque']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_passbook_cheque'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="reference_aadhar_photo_1" class="fw-semibold">Reference Aadhaar photo 1<span class="red">(*)</span>: </label>
                                                        <input type="file" name="reference_aadhar_photo_1" class="form-control" id="reference_aadhar_photo_1" >
                                                        <?= isset($employee['doc_reference_aaddhar_photo_1']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_reference_aaddhar_photo_1'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="reference_aadhar_photo_2" class="fw-semibold">Reference Aadhaar photo 1<span class="red">(*)</span>: </label>
                                                        <input type="file" name="reference_aadhar_photo_2" class="form-control" id="reference_aadhar_photo_2" >
                                                        <?= isset($employee['doc_reference_aaddhar_photo_2']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_reference_aaddhar_photo_2'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="mb-3">
                                                        <label for="education_certificate" class="fw-semibold">Education certificate photo<span class="red">(*)</span>: </label>
                                                        <input type="file" name="education_certificate" class="form-control" id="education_certificate" >
                                                        <?= isset($employee['doc_education_certificate']) ? '<img width="150" height="150" src="' . $filePath . $employee['doc_education_certificate'] . '" />' : "" ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1">
                                            <input class="btn btn-primary text-dark w-100" type="submit" name="submit" value="<?= isset($employee['id']) ? "Update" : "Save" ?> ">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- [ Main Content ] end -->
    <?= $this->include('layouts/footer') ?>
    <script>
        $(document).ready(function () {
            $("#person_dob").datepicker({
                changeMonth: true,
                changeYear: true,
                yearRange: '-100:+0', // specifying a hard coded year range

            });
            $('#marital_status').on('change', function () {
                let marital_status = $(this).val();
                console.log(marital_status)
                if (marital_status == "Married") {
                    $('#spouse_name_div').show();
                } else {
                    $('#spouse_name_div').hide();
                }
            });
        });
    </script>