<?php

namespace App\Controllers;

use App\Models\CustomersModel;

class PasswordResetController extends BaseController {

    public function index(): string {

        if (isset($_POST['email'])) {
            $userModel = new CustomersModel();
            $user_email = $this->request->getVar('email');
            $user_data = $userModel->where('customer_email', $user_email)->first();
            if (!empty($user_data)) {
                $email_data = $user_data['customer_email'];

                $email = service('email');
                $config['mailType'] = 'html';

                $email->initialize($config);

                $email->setFrom('admin@example.com', 'Admin');
                $email->setTo($email_data);
//                $email->setCC('another@another-example.com');
//                $email->setBCC('them@their-example.com');

                $email->setSubject('Reset Password on Presecure');
                $six_digit_random_number = random_int(100000, 999999);

                $email->setMessage(''
                        . '<a href="https://presecure.mwsserver.co.in/reset-password">Click here to reset password</a>'
                        . 'using below confirmation OTP: ' . $six_digit_random_number);

                $res = $email->send();

                if ($res) {
                    $data = [
                        'password_reset_otp' => $six_digit_random_number,
                        'password_reset_at' => date('Y-m-d H:i:s'),
                    ];
                    $userModel->update($user_data['id'], $data);
                }
                $this->session->markAsFlashdata('success');
                $this->session->setFlashdata('success', 'An email has sent to above email id. Please follow instructions to change password.');
            } else {
                $this->session->markAsFlashdata('msg');
                $this->session->setFlashdata('msg', 'Email is not exist. Please check email again');
            }
        }
        return view('forgot_password');
    }

    public function reset() {
        if (!empty($_POST['otp'])) {
            $rules = [
                'otp' => 'required|min_length[6]|max_length[6]',
                'new_password' => 'required|min_length[4]|max_length[50]',
                'confirm_password' => 'matches[new_password]'
            ];

            if ($this->validate($rules)) {
                $userModel = new CustomersModel();
                $user_otp = $this->request->getVar('otp');
                $user_data = $userModel->where('password_reset_otp', $user_otp)->first();
                if (!empty($user_data)) {
                    $new_password = $this->request->getVar('new_password');
                    $data = [
                        'customer_password' => password_hash($new_password, PASSWORD_DEFAULT),
//                        'password_reset_otp' => $six_digit_random_number,
                        'password_reset_at' => date('Y-m-d H:i:s'),
                    ];
                    $userModel->update($user_data['id'], $data);
                    $this->session->markAsFlashdata('success');
                    $this->session->setFlashdata('success', 'Password change Successfully. Please login.');

                    return view('reset_password');
                } else {
                    $this->session->markAsFlashdata('msg');
                    $this->session->setFlashdata('msg', 'Otp enter is not valid. Please try again');
                }
            } else {
                $data['validation'] = $this->validator;
                echo view('reset_password', $data);
            }
        }
        return view('reset_password');
    }
}
