<?php

namespace App\Models;

use CodeIgniter\Model;

class BankDetailsModel extends Model {

    protected $table = 'bank_details';
    protected $allowedFields = [
        'customer_id',
        'bank_name',
        'account_no',
        'ifsc_code',
        'branch_name',
        'created_at',
        'updated_at'
    ];
    protected $useTimestamps = true;

  /**
     * @param false|string $id
     *
     * @return array|null
     */
    public function getBankDetails($id = false) {
        if ($id === false) {
            return $this->findAll();
        }

        return $this->where(['customer_id' => $id])->first();
    }
}
