<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Employee List</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/dataTables.bs5.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
                <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
                <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar') ?>
        <!--! [Start] Main Content !-->
        <!--! ================================================================ !-->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url().'dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Employee</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <!-- [ Main Content ] start -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-lg-1 mb-2">
                            <a class="btn btn-primary" href="<?= base_url() . 'agents-list' ?>">Back</a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card stretch stretch-full">
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-hover" id="customerList">
                                            <thead>
                                                <tr>
                                                    <th class="wd-30">
                                                        <div class="btn-group mb-1">
                                                            <div class="custom-control custom-checkbox ms-1">
                                                                <input type="checkbox" class="custom-control-input" id="checkAllCustomer">
                                                                <label class="custom-control-label" for="checkAllCustomer"></label>
                                                            </div>
                                                        </div>
                                                    </th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th>State</th>
                                                    <th>City</th>
                                                    <th>Pincode</th>
                                                    <th>Organization</th>
                                                    <th>Date</th>
                                                    <th class="text-end">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (!empty($employee_list)) :
                                                    foreach ($employee_list as $key => $c) :
                                                        ?>
                                                        <tr class="single-item">
                                                            <td>
                                                                <div class="item-checkbox ms-1">
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input checkbox" id="checkBox_1">
                                                                        <label class="custom-control-label" for="checkBox_1"></label>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div>
                                                                    <span class="text-truncate-1-line"><?= $c['person_name'] ?></span>
                                                                </div>
                                                            </td>
                                                            <td><?= $c['contact_no'] ?></td>
                                                            <td><?= $c['state'] ?></td>
                                                            <td><?= $c['city'] ?></td>
                                                            <td><?= $c['pincode'] ?></td>
                                                            <td><?= $c['organization'] ?></td>
                                                            <!--<td><?= $c['offer_letter'] != "" ? "Yes": "No" ?></td>-->
                                                            <td><?= date("d/m/Y", strtotime($c['created_at'])) ?></td>
                                                            <td>
                                                                <div class="hstack gap-2 justify-content-end">
                                                                    <a href="<?php echo base_url(); ?>agent/view-employee/<?= $c['id']; ?>" class="avatar-text avatar-md">
                                                                        <i class="feather feather-eye"></i>
                                                                    </a>
                                                                    <div class="dropdown">
                                                                        <a href="javascript:void(0)" class="avatar-text avatar-md" data-bs-toggle="dropdown" data-bs-offset="0,21">
                                                                            <i class="feather feather-more-horizontal"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu">
                                                                            <li>
                                                                                <a class="dropdown-item" href="<?php echo base_url(); ?>employee/add-file/<?= $c['id']; ?>">
                                                                                    <i class="feather feather-edit-3 me-3"></i>
                                                                                    <span>Add Offer letter</span>
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="<?php echo base_url(); ?>employee/delete/<?= $c['id']; ?>">
                                                                                    <i class="feather feather-trash-2 me-3"></i>
                                                                                    <span>Delete</span>
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    endforeach;
                                                endif;
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ Main Content ] end -->
            </div>
            <!-- [ Footer ] start -->
            <footer class="footer">
                <p class="fs-11 text-muted fw-medium text-uppercase mb-0 copyright">
                    <span>Copyright ©</span>
                    <script>
                        document.write(new Date().getFullYear());
                    </script>
                </p>
                <div class="d-flex align-items-center gap-4">
                    <a href="javascript:void(0);" class="fs-11 fw-semibold text-uppercase">Help</a>
                    <a href="javascript:void(0);" class="fs-11 fw-semibold text-uppercase">Terms</a>
                    <a href="javascript:void(0);" class="fs-11 fw-semibold text-uppercase">Privacy</a>
                </div>
            </footer>
            <!-- [ Footer ] end -->
        </main>
        <!--! ================================================================ !-->
        <!--! [End] Main Content !-->
        <!--! ================================================================ !-->
        <!--! Footer Script !-->
        <!--! ================================================================ !-->
        <!--! BEGIN: Vendors JS !-->
        <script src="<?= base_url(); ?>/assets/vendors/js/vendors.min.js"></script>
        <!-- vendors.min.js {always must need to be top} -->
        <script src="<?= base_url(); ?>/assets/vendors/js/dataTables.min.js"></script>
        <script src="<?= base_url(); ?>/assets/vendors/js/dataTables.bs5.min.js"></script>
        <script src="<?= base_url(); ?>/assets/vendors/js/select2.min.js"></script>
        <script src="<?= base_url(); ?>/assets/vendors/js/select2-active.min.js"></script>
        <!--! END: Vendors JS !-->
        <!--! BEGIN: Apps Init  !-->
        <script src="<?= base_url(); ?>/assets/js/common-init.min.js"></script>
        <script src="<?= base_url(); ?>/assets/js/customers-init.min.js"></script>
        <!--! END: Apps Init !-->
        <!--! BEGIN: Theme Customizer  !-->
        <script src="<?= base_url(); ?>/assets/js/theme-customizer-init.min.js"></script>
        <!--! END: Theme Customizer !-->
    </body>

</html>