<!DOCTYPE html>
<html lang="zxx">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="keyword" content="">
        <meta name="author" content="theme_ocean">
        <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
        <!--! BEGIN: Apps Title-->
        <title>Admin || Employee Bank Details</title>
        <!--! END:  Apps Title-->
        <!--! BEGIN: Favicon-->
        <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>/assets/images/favicon.ico">
        <!--! END: Favicon-->
        <!--! BEGIN: Bootstrap CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/bootstrap.min.css">
        <!--! END: Bootstrap CSS-->
        <!--! BEGIN: Vendors CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/vendors.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/select2-theme.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/vendors/css/datepicker.min.css">
        <!--! END: Vendors CSS-->
        <!--! BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>/assets/css/theme.min.css">
        <!--! END: Custom CSS-->
        <!--! HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries !-->
        <!--! WARNING: Respond.js doesn"t work if you view the page via file: !-->
        <!--[if lt IE 9]>
            <script src="https:oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https:oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>

    <body>
        <?= $this->include('layouts/header') ?>
        <?= $this->include('layouts/sidebar_customer') ?>
        <!-- [ Main Content ] start -->
        <main class="nxl-container">
            <div class="nxl-content">
                <!-- [ page-header ] start -->
                <div class="page-header">
                    <div class="page-header-left d-flex align-items-center">
                        <div class="page-header-title">
                            <h5 class="m-b-10">Employee</h5>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() . 'customer-dashboard' ?>">Dashboard</a></li>
                            <li class="breadcrumb-item">Bank Details</li>
                        </ul>
                    </div>
                </div>
                <!-- [ page-header ] end -->
                <div class="main-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card border-top-0">
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="profileTab" role="tabpanel">
                                        <div class="card-body personal-info">
                                            <?php if (session()->getFlashdata('success') != null) { ?>
                                                <div class="alert alert-success">
                                                    <?= session()->getFlashdata('success') ?>
                                                </div>
                                            <?php }
                                            ?>
                                            <?php
                                            $errors = validation_errors();
                                            if (!empty($errors)):
                                                ?>
                                                <div class="alert alert-danger" role="alert">
                                                    <?php foreach ($errors as $error): ?>
                                                        <p><?= esc($error) ?></p>
                                                    <?php endforeach ?>
                                                </div>
                                            <?php endif ?>
                                            <form action="<?php echo base_url(); ?>customers/save-bank-details" method="post" >
                                                <?= csrf_field() ?>
                                                <input type="hidden" name="id" value="<?= $customer['id']; ?>">
                                                <input type="hidden" name="update_id" value="<?= !isset($bank['id']) ? 0 : $bank['id']; ?>">
                                                <div class="row mb-4 align-items-center">
                                                    <h2>Bank Details</h2>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="bank_name" class="fw-semibold">Bank name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="bank_name" value="<?= !isset($bank['bank_name']) ? set_value("bank_name") : $bank['bank_name'] ?>" class="form-control" id="bank_name">
                                                            <?php //echo validation_show_error('bank_name'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="account_no" class="fw-semibold">Account no: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="number" name="account_no" value="<?= !isset($bank['account_no']) ? set_value("account_no") : $bank['account_no'] ?>" class="form-control" id="account_no">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="ifsc_code" class="fw-semibold">IFSC code: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="ifsc_code" value="<?= !isset($bank['ifsc_code']) ? set_value("ifsc_code") : $bank['ifsc_code'] ?>" class="form-control" id="ifsc_code">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="branch_name" class="fw-semibold">Branch name: </label>
                                                    </div>
                                                    <div class="col-lg-8">
                                                        <div class="input-group">
                                                            <input type="text" name="branch_name" value="<?= !isset($bank['branch_name']) ? set_value("branch_name") : $bank['branch_name'] ?>" class="form-control" id="branch_name">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-4 align-items-center">
                                                    <div class="col-lg-4">
                                                        <label for="Input" class="fw-semibold"></label>
                                                    </div>
                                                    <div class="col-lg-1 ">
                                                        <input class="btn btn-primary text-dark w-100" type="submit" name="submit" value="<?= isset($bank['id']) ? "Submit" : "Save" ?>">
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- [ Main Content ] end -->
        <?= $this->include('layouts/footer') ?>