<?php 
	session_start();

	// connect to database
	$db = mysqli_connect('localhost', 'root', '', 'property_booking');

	// variable declaration
	$username = "";
	$email    = "";
	$errors   = array();

	// call the register() function if register_btn is clicked
	if (isset($_POST['register_btn'])) {
		register();
	}

	// call the login() function if register_btn is clicked
	if (isset($_POST['login_btn'])) {
		login();
	}

	// call the add_property() function if register_property is clicked
	if (isset($_POST['register_property'])) {
		add_property();
	}

	if (isset($_GET['logout'])) {
		session_destroy();
		unset($_SESSION['user']);
		header("location: ../login.php");
	}

	// REGISTER USER
	function register(){
		global $db, $errors;

		// receive all input values from the form
		$username    =  e($_POST['username']);
		$email       =  e($_POST['email']);
		$password_1  =  e($_POST['password_1']);
		$password_2  =  e($_POST['password_2']);

		// form validation: ensure that the form is correctly filled
		if (empty($username)) { 
			array_push($errors, "Username is required"); 
		}
		if (empty($email)) { 
			array_push($errors, "Email is required"); 
		}
		if (empty($password_1)) { 
			array_push($errors, "Password is required"); 
		}
		if ($password_1 != $password_2) {
			array_push($errors, "The two passwords do not match");
		}

		// register user if there are no errors in the form
		if (count($errors) == 0) {
			$password = md5($password_1);//encrypt the password before saving in the database

			if (isset($_POST['user_type'])) {
				$user_type = e($_POST['user_type']);
				$query = "INSERT INTO users (username, email, user_type, password) 
						  VALUES('$username', '$email', '$user_type', '$password')";
				mysqli_query($db, $query);
				$_SESSION['success']  = "New user successfully created!!";
				header('location: home.php');
			}else{
				$query = "INSERT INTO users (username, email, user_type, password) 
						  VALUES('$username', '$email', 'user', '$password')";
				mysqli_query($db, $query);

				// get id of the created user
				$logged_in_user_id = mysqli_insert_id($db);

				$_SESSION['user'] = getUserById($logged_in_user_id); // put logged in user in session
				$_SESSION['success']  = "You are now logged in";
				header('location: index.php');				
			}

		}

	}

	// return user array from their id
	function getUserById($id){
		global $db;
		$query = "SELECT * FROM users WHERE id=" . $id;
		$result = mysqli_query($db, $query);

		$user = mysqli_fetch_assoc($result);
		return $user;
	}

	// LOGIN USER
	function login(){
		global $db, $username, $errors;

		// grap form values
		$username = e($_POST['username']);
		$password = e($_POST['password']);

		// make sure form is filled properly
		if (empty($username)) {
			array_push($errors, "Username is required");
		}
		if (empty($password)) {
			array_push($errors, "Password is required");
		}

		// attempt login if no errors on form
		if (count($errors) == 0) {
			$password = md5($password);

			$query = "SELECT * FROM users WHERE username='$username' AND password='$password' LIMIT 1";
			$results = mysqli_query($db, $query);

			if (mysqli_num_rows($results) == 1) { // user found
				// check if user is admin or user
				$logged_in_user = mysqli_fetch_assoc($results);
				if ($logged_in_user['user_type'] == 'admin') {

					$_SESSION['user'] = $logged_in_user;
					$_SESSION['success']  = "You are now logged in";
					header('location: admin/index');		  
				}else{
					$_SESSION['user'] = $logged_in_user;
					$_SESSION['success']  = "You are now logged in";

					header('location: index');
				}
			}else {
				array_push($errors, "Wrong username/password combination");
			}
		}
	}

	function isLoggedIn()
	{
		if (isset($_SESSION['user'])) {
			return true;
		}else{
			return false;
		}
	}

	function isAdmin()
	{
		if (isset($_SESSION['user']) && $_SESSION['user']['user_type'] == 'admin' ) {
			return true;
		}else{
			return false;
		}
	}

	// escape string
	function e($val){
		global $db;
		return mysqli_real_escape_string($db, trim($val));
	}

	function display_error() {
		global $errors;

		if (count($errors) > 0){
			echo '<div class="alert alert-danger alert-dismissible fade show">
			<strong>Error!</strong><div class="error"><button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>';
				foreach ($errors as $error){
					echo $error .'<br>';
				}
			echo '</div>';
		}
	}


	// REGISTER property
	function add_property(){
		global $db, $errors;
		//$maxsize = 5242880; // 5MB
		$maxsize = 262144000; //250MB

		//error_reporting(0);

		// receive all input values from the form
		$pro_type    =  e($_POST['pro_type']);
		$pro_status       =  e($_POST['pro_status']);
		$pro_price  =  e($_POST['pro_price']);
		$max_rooms  =  e($_POST['max_rooms']);
		$beds  =  e($_POST['beds']);
		$bath  =  e($_POST['bath']);
		$area  =  e($_POST['area']);
		$price  =  e($_POST['price']);
		$premiere  =  e($_POST['premiere']);
		$description  =  e($_POST['description']);
		$address  =  e($_POST['address']);
		$zipcode  =  e($_POST['zipcode']);
		// Get the selected checkbox values
		$additional_features = $_POST['techno'];
		//Convert the array to a string
		$chk = implode(",", $additional_features);


		// image file store in data and also images folder
		$filename = $_FILES["uploadfile"]["name"];
		$tempname = $_FILES["uploadfile"]["tmp_name"];
		$folder = "../images/" . $filename;

		//video file store in database and also videos folder
		$name = $_FILES['file']['name'];
        $target_dir = "../videos/";
        $target_file = $target_dir . $_FILES["file"]["name"];

        // Select file type
        $videoFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

        // Valid file extensions
        $extensions_arr = array("mp4","avi","3gp","mov","mpeg");
		
		// form validation: ensure that the form is correctly filled
		if (empty($pro_type)) { 
			array_push($errors, "Property Type is required"); 
		}
		if (empty($pro_status)) { 
			array_push($errors, "Property Status is required"); 
		}
		if (empty($pro_price)) { 
			array_push($errors, "Property Price is required"); 
		}
		if(empty($max_rooms))
		{
			array_push($errors, "Max Rooms is requierd");
		}
		if(empty($additional_features))
		{
			array_push($errors, "Additional Features is requierd");
		}
		
			if (count($errors) == 0) {
	
				if( in_array($videoFileType,$extensions_arr) ){
					// Check file size
					if(($_FILES['file']['size'] >= $maxsize) || ($_FILES["file"]["size"] == 0)) {
						echo "File too large. File must be less than 250MB.";
					}else{
						// Upload
						if(move_uploaded_file($_FILES['file']['tmp_name'],$target_file) && move_uploaded_file($tempname, $folder)){
							// Insert record
							$sql = "INSERT INTO add_property(pro_type, pro_status, pro_price, max_rooms, beds, bath, area, price, premiere, description, address, zipcode, filename, video, additional_features) VALUES ('$pro_type', '$pro_status', '$pro_price', '$max_rooms', '$beds', '$bath', '$area', '$price', '$premiere', '$description', '$address', '$zipcode', '$filename', '$target_file', '$chk')";

							// Execute query
							mysqli_query($db, $sql);
							$_SESSION['success']  = "New property successfully added.!!";
							//header('location: index');
						}
					}
				}else{
					$_SESSION['success']  = "Invalid file extension.";			
				}
	
			}
	}

?>