<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Company;

class CompanyController extends Controller
{
    public function __construct(){
        $this->middleware('auth');
    } 

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   $breadcrumbs = ['home'=>'Dashboard','company.index'=>'Companies']; 
        $all_result  = Company::whereUserId(Auth::id())->paginate(10);
        return view('theme.company.index',['response'=>$all_result,'breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $breadcrumbs = ['home'=>'Dashboard','company.index'=>'Companies','javascript:void(0)'=>'Add Company']; 
        return view('theme.company.add',['breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       if($request->isMethod('post')) 
       {
        $validate = $request->validate(['name'=>'required|max:222',
                                        'address'=>'required|max:320',
                                        'gst'=>'required|max:15|min:15|unique:companies',
                                        'pan'=>'required|min:10|max:11|unique:companies']);
        Company::create(['user_id'=>Auth::id(),'name'=>$request->name,'address'=>$request->address,'gst'=>$request->gst,'pan'=>$request->pan,'is_active'=>$request->is_active]);
        return redirect()->route('company.index')->with('info','Company Save Successful.');
       }else{
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $find_company_result = Company::findOrFail($id);
        $breadcrumbs = ['home'=>'Dashboard','company.index'=>'Companies','javascript:void(0)'=>'Edit Company']; 
        return view('theme.company.edit',['rows'=>$find_company_result,'breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

       if($request->isMethod('put')) 
       {
        $validate = $request->validate(['name'=>'required|max:222',
                                        'address'=>'required|max:320',
                                        'gst'=>'required|max:15|min:15|unique:companies',
                                        'pan'=>'required|min:10|max:11|unique:companies']);
        Company::findOrFail($id)->update($request->all());
        return redirect()->route('company.index')->with('info','Company Updated Successful.');
       }else{
        return back()->with('error','Bad Method Call.');
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
      if($request->isMethod('delete')) 
      {
        Company::findOrFail($id)->delete();
        return redirect()->route('company.index')->with('info','Company Deleted Successful.');
      }else{
        return back()->with('error','Bad Method Call.');
      }
    }
}
