<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Collection;
use DB;
use Http;
use Curl;
use App\Models\Contact;
use App\Models\Demo;
use App\Models\Page;
use App\Models\User;
use App\Models\Service;
use App\Models\Product;

class PageController extends Controller
{
    public function index(Request $request,$slug)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        if($request->segment(1)=='pages'){
            $slug = $request->segment(2);             
            $pages_result = Page::whereSlug($slug)->whereIs_active(1)->first();
        }

        return view('storefront.pages.help')->with(['pages_result'=>$pages_result,'collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1]);
    }
    public function services(Request $request)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        $response = Service::whereIs_active(1)->latest()->paginate(100);

        return view('storefront.pages.service')->with(['response'=>$response,'collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1]);
    }

    public function services_details(Request $request,$slug)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        $response = Service::whereSlug($slug)->whereIs_active(1)->first();

        return view('storefront.pages.service_details')->with(['rows'=>$response,'collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1]);
    }

    
    public function blog(Request $request)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        $response = Product::join('product_details','products.id','=','product_details.product_id')
                           ->join('product_images','products.id','=','product_images.product_id')
                           ->where('products.is_active',1)
                           ->paginate(100);

        return view('storefront.pages.blog')->with(['response'=>$response,'collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1]);
    }

    public function blog_details(Request $request,$slug)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        $response = Product::join('product_details','products.id','=','product_details.product_id')
        ->join('product_images','products.id','=','product_images.product_id')
        ->where('products.is_active',1)
        ->where('products.slug',$slug)
        ->first();

        return view('storefront.pages.blog_details')->with(['rows'=>$response,'collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1]);
    }

    public function demo(Request $request)
    {            
        if($request->isMethod('post'))
        {
            $Register = new Demo;
            $requestEmail = $request['email'];
            $datalist = Demo::where('email', $requestEmail)->get();
        
            $dataCount = $datalist->count();
            if ($dataCount <= 0) {
              $Register->email = $requestEmail;
              $Register->save();
              return response()->json(['success' => true, 'status' => 200, 'msg' => 'Thank you for Subscribing Us']);
            } else {
              return response()->json(['success' => false, 'status' => 200, 'msg' => 'You have already Subscribed']);
            }
        

        }
    }
    public function contact_us(Request $request)
    {            
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        if($request->isMethod('post'))
        {
            $request->validate(['name'=>'required',
                                'email'=>'required|email',
                                'mobile'=>'required',
                                'description'=>'required']);
            $contact_array['name']      = $request->name;    
            $contact_array['email']     = $request->email;    
            $contact_array['mobile']    = $request->mobile;    
            $contact_array['message']   = $request->description;    
            $contact_array['ip']= $request->ip();    
            $contact_array['created_at']= date('Y-m-d H:i:s');    

            Contact::insert($contact_array);
            return back()->with('warning','Your Enquiry Sent Successful.');
        }
        return view('storefront.pages.contact-us',['collections'=>$collections,'users'=>$users]);
    }

    public function awards(Request $request)
    {      
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     
        $response = DB::table('awards')->orderBy('id','Asc')->get();
        return view('storefront.awards.awards')->with(['collections'=>$collections,'users'=>$users,'cat_response'=>$cat_response1,'response'=>$response]);
    }

    public function trackdata(Request $request)
    {      

        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();  
        $cat_response1 = Collection::whereIs_active(1)->orderBy('name','Asc')->take(4)->get();     



        if($request->has('trackingId')){

          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL,'https://cms.getfitpro.in/api/get-tracking?trackingId='.$request->trackingId);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          $response = curl_exec($ch);
          $result = json_decode($response);
          curl_close($ch); // Close the connection

            if(count($result)>0){
                return view('storefront.pages.trackdata',['collections'=>$collections,'users'=>$users,'response'=>$result]);            
            }
        }else{
            
            $response = ['data'=>false];
            return view('storefront.pages.trackdata',['collections'=>$collections,'users'=>$users,'response'=>$response]);
        }

    }


}