<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id()->comment('PRIMARY ID');
            $table->foreignId('user_id')->comment('user_id');
            $table->foreign('user_id')->references('id')->on('users'); 
            $table->bigInteger('productId')->unique()->comment('unique_product_id');
            $table->text('name')->comment('product_title');
            $table->text('slug')->unique()->comment('handle');
            $table->double('selling_price')->default(0)->comment('selling_price');            
            $table->double('actual_price')->default(0)->comment('actual_price');            
            $table->double('cod_amount')->default(0)->comment('cod_actual_price');            
            $table->double('prepaid_amount')->default(0)->comment('prepaid_actual_price');            
            $table->bigInteger('shipping_amount')->default(0)->comment('shipping_price');
            $table->bigInteger('in_stock')->default(0)->comment('Stock Avaliablity');
            $table->tinyInteger('is_cod')->default(0)->comment('COD STATUS');
            $table->tinyInteger('is_prepaid')->default(0)->comment('PREPAID STATUS');
            $table->tinyInteger('in_shopify')->default(0)->comment('LISTED BY');
            $table->integer('sort_by')->default(0)->comment('SORT BY');
            $table->tinyInteger('is_active')->default(0)->comment('ACTIVE STATUS');
            $table->timestamps();
            $table->index('id');
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
