<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="{{ asset('images/icon.png')}}" />
    <title>India&#x27;s Largest online store for Mobiles, Fashion , Electronics, Home Appliances, Books, Jewelry, Home, Furniture, Sporting goods, Beauty &amp; Personal Care, Grocery and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card &amp; more.</title>
    <meta name="Description"
        content="India's Best Online store for Mobiles, Mobile Accessories, Electronics, and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card " />
    <meta name="Keywords"
        content="Online Shopping in India,online Shopping store,Online Shopping Site,Buy Online,Shop Online,Online Shopping {{ config('app.name') }}" />
    <meta name='og:description'
        content="India&#x27;s Largest online store for Mobiles, Fashion , Electronics, Home Appliances, Books, Jewelry, Home, Furniture, Sporting goods, Beauty &amp; Personal Care, Grocery and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card &amp; more.">
    <meta property="og:type" content="website" />
    <meta name="og_site_name" property="og:site_name" content="{{ config('app.name') }}" />
    <meta property="og:image" itemprop="image primaryImageOfPage" content="{{ asset('images/icon.png')}}" />
    <meta name="og:title" content="Online Shopping Site for Mobiles, Electronics, Books &amp; More. Best Offers!">
    <meta name='og:description'
        content="India&#x27;s Largest online store for Mobiles, Fashion , Electronics, Home Appliances, Books, Jewelry, Home, Furniture, Sporting goods, Beauty &amp; Personal Care, Grocery and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card &amp; more.">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset('css/plugins.css')}}">
    <link rel="stylesheet" href="{{ asset('css/style.css')}}">
    <link rel="stylesheet" href="{{ asset('css/responsive.css')}}">
</head>

<body class="template-index index-demo2 modal-popup-style">
    @include('storefront.partials.loader')
    <div class="page-wrapper">
        @include('storefront.partials.header2')
        <div id="page-content">
            <!--Home slider-->
            <div class="breadcrumbs-wrapper">
                <div class="container">
                    <div class="breadcrumbs"><a href="{{ url('/') }}" title="Back to the home page">Home</a> <span
                            aria-hidden="true">|</span> <span>{{ ucwords(Request::segment(2)) }}</span></div>
                </div>
            </div>
            <!--End Home slider-->
            <!--Body Container-->
            <div class="container">
                <div class="row">
                    <!--Main Content-->
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 main-col">
                        <!--Product Grid-->
                        <div class="product-load-more">
                            <div class="grid-products grid--view-items">
                                <div class="row">
                                    @foreach($result as $key=>$rows)
                                    <div class="col-6 col-sm-6 col-md-4 col-lg-3 item" title="{{ $rows->name }}"
                                        style="display: block;">
                                        <div class="product-image">
                                            <a href="{{ route('store.fetch-single-pro',$rows->slug) }}" target="_blank"
                                                title="BUY NOW" class="product-img">
                                                <img class="primary blur-up lazyloaded" data-src="{{ $rows->image }}"
                                                    src="{{ $rows->image }}" alt="" title="">
                                                <img class="hover blur-up lazyloaded" data-src="{{ $rows->image }}"
                                                    src="{{ $rows->image }}" alt="" title="">
                                            </a>
                                        </div>
                                        <!-- end product image -->
                                        <!--start product details -->
                                        <div class="product-details text-center">
                                            <!-- product name -->
                                            <div class="product-name">
                                                <a href="{{ route('store.fetch-single-pro',$rows->slug) }}"
                                                    target="_blank" title="BUY NOW">{{ $rows->name }}</a>
                                            </div>
                                            <!-- End product name -->
                                            <!-- product price -->
                                            <div class="product-price">
                                                <p class="product-price grid-view-item__meta">
                                                    <span class="old-price"><i class="fa fa-inr"></i>{{
                                                        number_format($rows->actual_price,0) }}/-</span>
                                                    <span class="product-price__price product-price__sale"><span
                                                            class="money"><i class="fa fa-inr"></i>{{
                                                            number_format($rows->prepaid_amount,0)
                                                            }}</span></span></span>
                                                </p>
                                            </div>
                                            <!-- End product price -->
                                            <!--Product Review-->
                                            <div class="product-review">
                                                <span>
                                                    <span
                                                        style="font-size: 11px; background-color: #086608; color: #fff;"
                                                        class="in_stock badge badge-success">4.{{ rand(1,5) }} <i
                                                            class="fa fa-star text-white"
                                                            style="font-size: 11px;"></i></span> ({{ rand(111,999) }}
                                                    Ratings & {{ rand(444,999)}} Reviews)</span>
                                            </div>
                                            <!--End Product Review-->
                                        </div>
                                        <!-- End product details -->
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            <!--End Product Grid-->
                        </div>
                    </div>
                    <!--End Main Content-->
                </div>
            </div>
            <!--End Body Container-->
        </div>
        <!--End Page Wrapper-->

        @include('storefront.partials.footer')

        <script src="{{ asset('js/vendor/jquery-min.js')}}"></script>
        <script src="{{ asset('js/vendor/js.cookie.js')}}"></script>
        <script src="{{ asset('js/plugins.js')}}"></script>
        <script src="{{ asset('js/main.js')}}"></script>
</body>

</html>