<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>{{ $rows->name }} Online at Best Price On {{ config('app.name') }}</title>
    <meta name="Keywords" content="Buy {{ $rows->name }}" />
    <meta name="Description" property="description" content=" {{ $rows->name }} performance to shop at {{ config('app.name') }}" />
    <meta name="og:title" property="og:title" content="{{ $rows->name }} Online at Best Price on {{ config('app.name') }}" />
    <meta property="og:image" content="{{ $rows->image }}" />
    <meta name="Description" property="og:description" content=" {{ $rows->name }} performance to shop at {{ config('app.name') }}" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <link rel="icon" href="{{ $rows->image }}" type="image/png" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/materializeCss.css')}}" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/bootstrapCss.css')}}" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/viewportCss.css')}}" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/customStyles.css')}}" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/swiperCss.css')}}" />
    <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/customCssV16.css')}}" />
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="prefetch" as="style" onload="this.rel='stylesheet'" />
    <link href="{{ asset('storefront/mobile/Styles/jquery-ui.css')}}" rel="preload" as="style" onload="this.rel='stylesheet'" />
    <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/mobilejqueryJs.js')}}"></script>
    <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/mobilejqueryUiJs.js')}}"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/lightgallery.css')}}" />
    <link rel="stylesheet" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/video-js.css')}}" />
    <link rel="stylesheet" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/flexsliderCss.css')}}" />
    <link rel="stylesheet" href="https://ready4shops.com/public/assets/storefront/plugins/swiper/swiper.min.css">
    <link rel="stylesheet" type="text/css" href="https://ready4shops.com/public/assets/storefront/dist/css/xzoom.css" media="all"/>
    <style>
        .swiper-container {
            width: 100%;
            height: 100%;
        }
        .swiper-slide {
            text-align: center;
            font-size: 18px;
            background: #fff;
            display: -webkit-box;
            display: -ms-flexbox;
            display: -webkit-flex;
            display: flex;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            -webkit-justify-content: center;
            justify-content: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            -webkit-align-items: center;
            align-items: center;
        }
        .productSliderArea .swiper-container-android .swiper-slide,
        .swiper-wrapper {
            width: 100% !important;
        }
        .keyFeaturesArea.lnkProductDeatils img {
            max-width: 100%;
            max-height: 100%;
            height: inherit !important;
        }
    </style>
    <style>
        .stButton .stLarge:hover {
            opacity: 0.75;
            background-position: 0;
        }
    </style>
    <style>
        .offerCustList {
            list-style-type: none;
            margin-left: 0;
        }
        .offerCustList li img {
            margin-right: 5px;
            width: 18px;
            height: 18px;
        }
        .offerCustList li {
            font-family: "Roboto", sans-serif;
            font-size: 12px;
            margin-bottom: 5px;
        }
        .offerCustList li a {
            color: #f95d54;
        }
        .offerCustomTerms {
            height: 300px;
            overflow-y: scroll;
        }
        .flexslider .slides > li {
            position: relative;
        }
    </style>
    <style type="text/css">
        #st-1 {
            font-family: "Helvetica Neue", Verdana, Helvetica, Arial, sans-serif;
            direction: ltr;
            display: block;
            opacity: 1;
            text-align: right;
            z-index: 94034;
        }
        #st-1.st-animated {
            -moz-transition: o 0.2s ease-in, p 0.2s ease-in, a 0.2s ease-in, c 0.2s ease-in, i 0.2s ease-in, t 0.2s ease-in, y 0.2s ease-in;
            -ms-transition: o 0.2s ease-in, p 0.2s ease-in, a 0.2s ease-in, c 0.2s ease-in, i 0.2s ease-in, t 0.2s ease-in, y 0.2s ease-in;
            -o-transition: o 0.2s ease-in, p 0.2s ease-in, a 0.2s ease-in, c 0.2s ease-in, i 0.2s ease-in, t 0.2s ease-in, y 0.2s ease-in;
            -webkit-transition: o 0.2s ease-in, p 0.2s ease-in, a 0.2s ease-in, c 0.2s ease-in, i 0.2s ease-in, t 0.2s ease-in, y 0.2s ease-in;
            transition: o 0.2s ease-in, p 0.2s ease-in, a 0.2s ease-in, c 0.2s ease-in, i 0.2s ease-in, t 0.2s ease-in, y 0.2s ease-in;
        }
        #st-1.st-hidden {
            opacity: 0;
        }
        #st-1.st-hide {
            display: none;
        }
        #st-1 .st-btn {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            -moz-transition: opacity 0.2s ease-in, top 0.2s ease-in;
            -ms-transition: opacity 0.2s ease-in, top 0.2s ease-in;
            -o-transition: opacity 0.2s ease-in, top 0.2s ease-in;
            -webkit-transition: opacity 0.2s ease-in, top 0.2s ease-in;
            transition: opacity 0.2s ease-in, top 0.2s ease-in;
            -moz-border-radius: 4px;
            -webkit-border-radius: 4px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            display: inline-block;
            font-size: 11px;
            height: 32px;
            line-height: 32px;
            margin-right: 8px;
            padding: 0 8px;
            position: relative;
            text-align: center;
            top: 0;
            vertical-align: top;
            white-space: nowrap;
        }
        #st-1 .st-btn:last-child {
            margin-right: 0;
        }
        #st-1 .st-btn > svg {
            height: 16px;
            width: 16px;
            position: relative;
            top: 8px;
            vertical-align: top;
        }
        #st-1 .st-btn > img {
            display: inline-block;
            height: 16px;
            width: 16px;
            position: relative;
            top: 8px;
            vertical-align: top;
        }
        #st-1 .st-btn > span {
            -moz-transition: all 0.2s ease-in;
            -ms-transition: all 0.2s ease-in;
            -o-transition: all 0.2s ease-in;
            -webkit-transition: all 0.2s ease-in;
            transition: all 0.2s ease-in;
            color: #fff;
            display: inline-block;
            font-weight: 500;
            letter-spacing: 0.5px;
            min-width: 60px;
            opacity: 1;
            padding: 0 6px;
            position: relative;
            vertical-align: top;
        }
        #st-1.st-has-labels .st-btn {
            min-width: 120px;
        }
        #st-1.st-has-labels .st-btn.st-remove-label {
            min-width: 50px;
        }
        #st-1.st-has-labels .st-btn.st-remove-label > span {
            display: none;
        }
        #st-1.st-has-labels .st-btn.st-hide-label > span {
            display: none;
        }
        #st-1 .st-total {
            color: #555;
            display: inline-block;
            font-weight: 500;
            line-height: 12px;
            margin-right: 0;
            max-width: 80px;
            padding: 4px 8px;
            text-align: center;
        }
        #st-1 .st-total.st-hidden {
            display: none;
        }
        #st-1 .st-total > span {
            font-size: 16px;
            line-height: 17px;
            display: block;
            padding: 0;
        }
        #st-1 .st-total > span.st-shares {
            font-size: 9px;
            line-height: 9px;
        }
        #st-1.st-justified {
            display: flex;
            text-align: center;
        }
        #st-1.st-justified .st-btn {
            -moz-flex: 1;
            -ms-flex: 1;
            -webkit-flex: 1;
            flex: 1;
        }
        #st-1 .st-btn:hover {
            opacity: 0.8;
            top: -4px;
        }
    </style>
</head>
<body data-new-gr-c-s-check-loaded="14.1005.0" data-gr-ext-installed="">
        @include('storefront.partials.loader')
        <div id="o-wrapper" class="o-wrapper">
        @include('storefront.partials.header')
        <div id="SearchAutocompleteDiv" class="FilterLists" style="display: none;"></div>
        <div id="dvContainer">
            <div id="bodyContainer">
                <section class="ProductDetailsSection">
                    <div class="container">
                        <div class="productDescripTop">
                            <div class="productSliderArea">
                                <div class="img-detail-wrapper">
                                    <!-- lens options start -->
                                    <div class="xzoom-container">
                                        <div class="row box">
                                            <div class="col-md-12 col-12">
                                                <img
                                                    class="xzoom3"
                                                    src="{{ App\Models\Product_image::where('product_id',$rows->id)->where('is_main',1)->value('mainimage') }}"
                                                    xoriginal="{{ App\Models\Product_image::where('product_id',$rows->id)->where('is_main',1)->value('mainimage') }}"
                                                />
                                            </div>
                                            <br>
                                            <div class="col-md-2 col-3" style="width:100px;">
                                                <div class="xzoom-thumbs">                                                    
                                                  @php
                                                    $product_images=App\Models\Product_image::where('product_id',$rows->id)->orderBy('is_main','Desc')->get();
                                                  @endphp     
                                                    @if(count($product_images)>0)
                                                                @foreach ($product_images as $key=>$img)
                                                                    <a href="{{$img->mainimage }}" style="display:inline-block;">
                                                                        <img
                                                                            class="xzoom-gallery3"
                                                                            width="100%"
                                                                            src="{{$img->mainimage }}"
                                                                            xpreview="{{$img->mainimage }}"
                                                                            title="{{$rows->name }}"
                                                                        />
                                                                    </a>
                                                                @endforeach
                                                       @endif         
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="demo-gallery" style="display:none;">
                                    <div class="flexslider">
                                        <div class="flex-viewport" style="overflow: hidden; position: relative;">
                                            <ul id="lightgallery" class="slides" style="width: 1200%; transition-duration: 0s; transform: translate3d(0px, 0px, 0px);">
                                              @php
                                                $product_images = App\Models\Product_image::where('product_id',$rows->id)->get();
                                              @endphp     
                                                @if(count($product_images)>0)
                                                            @foreach ($product_images as $key=>$img)
                                                                <li
                                                                    data-thumb="null"
                                                                    data-src="{{$img->mainimage }}"
                                                                    data-thumb-alt=""
                                                                    style="width: 330px; margin-right: 0px; float: left; display: block;"
                                                                >
                                                                    <a href="#">
                                                                        <picture>
                                                                            <source
                                                                                type="image/webp"
                                                                                media="(min-width: 320px)"
                                                                                srcset="{{$img->mainimage }}"
                                                                            />
                                                                            <img src="{{$img->mainimage }}" draggable="false" />
                                                                        </picture>
                                                                    </a>
                                                                </li>
                                                            @endforeach
                                                   @endif         
                                            </ul>
                                        </div>
                                        <ol class="flex-control-nav flex-control-thumbs">
                                            @foreach ($product_images as $key=>$img)
                                                <li class="active"><img src="{{$img->mainimage }}" class="flex-active" draggable="false" /></li>
                                            @endforeach

                                        </ol>
                                    </div>
                                </div>
                                <div class="WarrantyBazaarArea single_btn CartButtonWebsite" style="display: none;">
                                    <div class="CartBuyBtn fixed">
                                        <ul>
                                            <li><a href="#" class="addtoCart lnkAddToCart" data-isextendedwarranty="0" data-id="72230" data-stock="0" data-prodtype="5" data-rippleria="">Add to Cart</a></li>
                                            <li><a href="#" class="BuyNow lnkBuyNow" data-isextendedwarranty="0" data-id="72230" data-stock="0" data-prodtype="5" data-rippleria="">Buy Now</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="productTitleArea productDescriptionScroller">
                                <div class="topContentSection">
                                    <h1>{{$rows->name }} <span class="in_stock">In stock</span></h1>
                                    <div class="reviewArea lnkgotoRating"></div>                                    
                                    <h6> <span><span style="font-size: 15px;background-color: #086608;color: #fff;" class="in_stock badge badge-success" style="background-color:green !important;color: #fff;">4.{{ rand(1,5) }} <i class="fa fa-star"></i></span> ({{ rand(111,999) }} Ratings & {{ rand(444,999)}} Reviews)</span></h6>
                                   &nbsp;  <h2 class="price_rate">
                                        <i class="fa fa-inr"></i>{{ number_format($rows->prepaid_amount,0) }}<span class="lineThrough"><i class="fa fa-inr"></i>{{ number_format($rows->actual_price,0) }}</span> <span class="DiscountOff">{{ number_format((($rows->prepaid_amount/$rows->actual_price)*100),0) }}% Off</span>
                                    </h2>
                                </div>
                                <div class="proDetailsPageCard assuredSection easyEmiSection">
                                    <div class="headerTitleArea">
                                        <h4 class="TitleText">Easy Payment Options</h4>
                                    </div>

                                    <div class="promiseDetailsArea">
                                        <form method="POST" action="{{ route('store.add-to-cart',$rows->id) }}" id="add-to-cart">
                                            @csrf

                                        @if($rows->prepaid_amount>0 && $rows->is_prepaid==1)
                                        <div class="cardSection addonOffer">
                                            <label for="EMIoption4">
                                                <input name="EasyPaymentOptGroup" id="EMIoption4" data-id="3" data-ptype="3" value="PREPAID" required="required" type="radio" />
                                                <span>
                                                    <h4>
                                                        Special Offer <span><img src="{{asset('storefront/images/A-EasyPaymentOptionImage-69-A8kIa.SVG')}}" class="img-responsive" alt="Special Offer" /></span>
                                                    </h4>
                                                    <div class="addressDetails">
                                                        <p>Get Additional Discount up to Rs.{{$rows->selling_price-$rows->prepaid_amount}}/- on Debit / Credit Card / UPI / Net Banking</p>
                                                        <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->prepaid_amount,0) }}</p>
                                                    </div>
                                                </span>
                                            </label>
                                        </div>
                                        @endif
                                        @if($rows->cod_amount>0 && $rows->is_cod==1)
                                        <div class="cardSection addonOffer">
                                            <label for="EMIoption1">
                                                <input name="EasyPaymentOptGroup" id="EMIoption1" value="COD" data-id="1" data-ptype="1" required="required" type="radio" />
                                                <span>
                                                    <h4>
                                                        Cash On Delivery <span><img src="{{asset('storefront/images/A-EasyPaymentOptionImage-69-a6fXs.SVG')}}" class="img-responsive" alt="Cash On Delivery" /></span>
                                                    </h4>
                                                    <div class="addressDetails">
                                                        <p>Pay On Delivery is available. Delivery is available across all major Pin Code.</p>
                                                        <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->cod_amount,0) }}</p>
                                                    </div>
                                                </span>
                                            </label>
                                        </div>
                                        @endif
                                        @if($rows->token_amount>0 && $rows->is_partial==1)
                                        <div class="cardSection addonOffer">
                                            <label for="EMIoption2">
                                                <input name="EasyPaymentOptGroup" id="EMIoption2" data-id="2" data-ptype="2" value="TOKEN" required="required" type="radio" />
                                                <span>
                                                    <h4>
                                                        Book Now @ <i class="fa fa-inr"></i> {{ number_format($rows->token_amount,0) }} <span><img src="{{asset('storefront/images/A-EasyPaymentOptionImage-69-1tkhw.SVG')}}" class="img-responsive" alt="Book Now" /></span>
                                                    </h4>
                                                    <div class="addressDetails">
                                                        <p>Pay rest amount on delivery<!-- &amp; Save up to Rs. {{ number_format($rows->selling_price-$rows->partial_amount,0) }}/---></p>
                                                        <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->partial_amount,0) }}</p>
                                                    </div>
                                                </span>
                                            </label>
                                        </div>
                                        @endif
                                                <div class="WarrantyBazaarArea" style="margin-top: 5px;">
                                                    <div class="CartBuyBtn" style="background-color: #ff4a43;">
                                                      <a href="javascript:void(0);" onclick="add_to_cart()" style="color: #fff;" class="BuyNow buy_now lnkBuyNow btn-md" data-isextendedwarranty="0" type="submit"><i class="fa fa-bolt"></i> BUY NOW</a>
                                                    </div>
                                                </div>
                                        </form>        
                                    </div>
                                </div>


                                <div class="pincode_status proDetailsPageCard">
                                    <div class="delivery_pincode">
                                        <h4 class="TitleText" style="color: #312f34;"><b>Delivery</b></h4>
                                        <div class="inputArea">
                                        <div class="caard-title text-danger" style="font-weight: 700"><span id="pinResponse"></span></div>
                                            <div class="pincode"><input type="number" pattern="\d*" class="form-control" id="pincode" maxlength="6" placeholder="Check Delivery Service *" name="pincode" /></div>
                                            <div class="btnArea" data-prodid="71429" data-stockid="0"><a href="javascript:void(0);" class="check_pin updatePinBtn lnkPincode">Change</a></div>
                                        </div>
                                    </div>
                                    <div class="delivery_status" id="msgPincdoe">
                                        <p class="title">Usually delivered in : 3-4 days</p>
                                        <p>Enter pincode for exact delivery dates/charges</p>
                                    </div>
                                </div>


                                <div class="proDetailsPageCard assuredSection"><div class="headerTitleArea"><h4 class="TitleText" style="color:#312f34"><b>Onedealstore Promise</b></h4></div><div class="promiseDetailsArea"><ul><li><div class="iconArea"><img src="{{asset('storefront/images/NKABQ87BPI_NKABQ.png')}}" class="img-responsive center-block" alt="icon"></div><div class="txtArea"><h4>Quality Assured</h4><p>Quality Assured: 36 Rigorous Quality Checks</p></div></li><li><div class="iconArea"><img src="{{asset('storefront/images/ELDZKBEJ9O_ELDZK.png')}}" class="img-responsive center-block" alt="icon"></div><div class="txtArea"><h4>One Year Warranty</h4><p>This Product Comes With One Year Onedealstore Warranty</p></div></li><li><div class="iconArea"><img src="{{asset('storefront/images/HUTMJOUALF_4BECH.png')}}" class="img-responsive center-block" alt="icon"></div><div class="txtArea"><h4>Easy Return</h4><p>Hassle Free 3 Days Return or Replacement Window</p></div></li></ul></div></div>

                                <div class="productKeysArea">
                                    <!-- AddToAny BEGIN -->
                                    <div class="a2a_kit a2a_kit_size_32 a2a_default_style"> <a class="a2a_dd" href="https://www.addtoany.com/share"></a> <a class="a2a_button_whatsapp"></a> <a class="a2a_button_facebook"></a> <a class="a2a_button_twitter"></a> <a class="a2a_button_linkedin"></a> <a class="a2a_button_pinterest"></a> <a class="a2a_button_google_gmail"></a> </div>
                                    <script async src="https://static.addtoany.com/menu/page.js"></script>
                                    <!-- AddToAny END -->
                                    <img src="https://cdn.shopify.com/s/files/1/0276/1700/1547/files/check_out_img.png?731" align="left" height="auto" width="100%" style="max-width: 400px">
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="ProductDetailsSection1 bg-light p-3">
                    <div class="container">
                        <div id="ComparePanel" class="pro_dtls_Compare"></div>
                          <div class="productDescripTop">
                            <div class="productSliderArea table-responsive" style="margin-left:10px;">                        
                            <h1>Specification</h1>
                                {!! $rows->description !!}
                            </div>
                            </div>
                          </div>      
                        </div>
                    </div>
                </section>
            </div>
            <a href="#" class="scrollTopButton" style="display: none;"><i class="fa fa-angle-up" aria-hidden="true"></i></a>
        </div>
    </div>
  @include('storefront.partials.footer')
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/materializeJs.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/bootstrapJs.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/lightgalleryJs.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/retinaJs.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/swiperJs.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/menu.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/commonJsV2.js')}}"></script>
  <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/searchJs.js')}}"></script>

<script src="https://ready4shops.com/public/assets/storefront/plugins/jquery/jquery.min.js"></script>
<script src="https://ready4shops.com/public/assets/storefront/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="https://ready4shops.com/public/assets/storefront/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>

<!-- PLUGINS FOR CURRENT PAGE -->
<script src="https://ready4shops.com/public/assets/storefront/plugins/swiper/swiper.min.js"></script>
<script src="https://ready4shops.com/public/assets/storefront/dist/js/script.min.js"></script>
<script src="https://ready4shops.com/public/assets/storefront/dist/js/jquery.js"></script>
<!-- xzoom plugin here -->
<script type="text/javascript" src="https://ready4shops.com/public/assets/storefront/dist/js/xzoom.min.js"></script>
<script src="https://ready4shops.com/public/assets/storefront/dist/js/setup.js"></script>

<!-- PLUGINS FOR CURRENT PAGE -->
  <script>
    function buy_now(product_id)
    {
        var name = "{{ $rows->name }}";
        var price = "{{ $rows->selling_price }}";
        var image_path = "{{ $rows->image_path }}";
        var slug = "{{ $rows->slug }}";

        //   $(".ajax-load-loader").css("display","block");
        $.ajax({
            type: "POST",
            url: "{{ url('checkout/ajax-cart') }}",
            data: {
                'product_id': product_id,
                'name': name,
                'price': price,
                'quantity': 1,
                'slug': slug,
                'image_path': image_path
            },
            success: function (data) {
                if(data=='ok')
                {
                    window.parent.location = "{{ url('checkout/login') }}";
                }else{alert("Sorry you can't buy more than one product!")}
            }
        });
    }

    $('#product_discription').find('table').addClass('table table-bordered');
    $('#product_discription').find('thead').addClass('thead-light');
</script>


<script type="text/javascript">
    
    $("#pincode").keyup(function()
    {
        var pincode_length = this.value;
        if(pincode_length.length>6)
        {
            alert("Invalid Pincode");
            $("#pinResponse").html('<font color="red">Please Enter 6 Digits Valid Pincode</font>');
            $("#pincode").focus();
            return false;
        }
    });
    
    
    $(".check_pin").click(function (e) 
    {
        // if(e.which==13) {
        var pincode = $("#pincode").val();
        if (pincode.length > 6) {
            $("#pinResponse").html('<font color="red">Please Enter 6 Digits Valid Pincode</font>');
            $("#pincode").focus();
            return false;
        }
        if (pincode.trim() == '') {
            $("#pinResponse").html('<font color="red">Please Enter 6 Digits Valid Pincode</font>');
            $("#pincode").focus();
            return false;
        } else {
            $("#pincode").css('border', '');
            $.ajax({
                url: "{{ url('api/ajax-check-service-avaliability?pincode=')}}" + pincode,
                success: function (result) {
                    $("#pinResponse").html(result);
                }
            });
        }
        //}
    });
</script>

                                <script type="text/javascript">
                                        
                                        function add_to_cart(){

                                        if ($("input[name='EasyPaymentOptGroup']:checked").length == 0)    
                                        {
                                            alert('please check payment method!')
                                            return false;
                                        }else{
                                            document.getElementById('add-to-cart').submit();

                                        }

                                        }


                                </script>


</body>
</html>