@extends('theme.layouts.app') @section('content')

<style type="text/css">
    fieldset.scheduler-border {
        border: 1px groove #ddd !important;

        padding: 0 1.4em 1.4em 1.4em !important;

        margin: 0 0 1.5em 0 !important;

        -webkit-box-shadow: 0px 0px 0px 0px #000;

        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border {
        font-size: 1.2em !important;

        font-weight: bold !important;

        text-align: left !important;

        width: auto;

        padding: 0 10px;

        border-bottom: none;
    }
</style>

<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Inventory</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Product</a></li>
                            <li class="breadcrumb-item active">Product Add</li>
                        </ol>
                    </div>
                    <h4 class="page-title">Add Product</h4>
                </div>
            </div>
        </div>

        <form class="needs-validation parsley-examples" data-parsley-validate action="{{route('product.store')}}" method="POST" enctype="multipart/form-data" novalidate>
            @csrf
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                                <div class="form-group">
                                    <label for="input-3">Collections</label>
                                    <select name="collection" class="form-control" required>
                                        <option value="">:--Collection--:</option>
                                        @foreach(App\Models\Collection::get() as $key=>$pRows)
                                        <option value="{{$pRows->slug}}">{{$pRows->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Product Name*</label>
                                    <input type="text" class="form-control" name="name" onblur="productSlug(this.value)" placeholder="Product Name *" required />
                                    <div class="invalid-feedback">
                                        Please Enter Product Name.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Product SKU*</label>
                                    <input type="text" class="form-control" name="sku" placeholder="SKU *" required />
                                    <div class="invalid-feedback">
                                        Please Enter SKU.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Description</label>
                                    <textarea type="text" class="form-control" name="description" id="description" placeholder="Description" required></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Description.
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>SEO</i></legend>
                                <div class="form-group">
                                    <label for="input-1">Meta Title</label>
                                    <textarea type="text" class="form-control" name="meta_title" id="meta_title"  required="required" placeholder="Meta Title"></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Meta Title.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Meta Keyword</label>
                                    <textarea type="text" class="form-control" name="meta_keywords" required="required" placeholder="Meta Keyword"></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Meta Keyword.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Meta Description</label>
                                    <textarea type="text" class="form-control" name="meta_description"  required="required" placeholder="Meta Description"></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Meta Description.
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Pricing</i></legend>
                                <div class="row">
                                    <input type="hidden" value="1" name="quantity" />
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">MRP *</label>
                                            <input type="number" class="form-control" name="actual_price" placeholder="Actual Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter MRP.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">Selling Price *</label>
                                            <input type="number" class="form-control" name="selling_price" placeholder="Selling Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter Selling Price.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">COD Price *</label>
                                            <input type="number" class="form-control" name="cod_amount" placeholder="COD Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter COD Price.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">Prepaid Price *</label>
                                            <input type="number" class="form-control" name="prepaid_amount" placeholder="Prepaid Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter Prepaid Amount.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">Token Amount *</label>
                                            <input type="number" class="form-control" name="token_amount" placeholder="Token Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter Token Amount.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="prepaid">Partial Amount *</label>
                                            <input type="number" class="form-control" name="partial_amount" placeholder="Partial Price *" required />
                                            <div class="invalid-feedback">
                                                Please Enter Partial Amount.
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </fieldset>

                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Checkout Mode</i></legend>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="icheck-primary">
                                                <input type="checkbox" name="is_cod" value="1" id="is_cod" />
                                                <label for="cod_status">COD</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="icheck-primary">
                                                <input type="checkbox" name="is_prepaid" value="1" id="is_prepaid" />
                                                <label for="prepaid_status">Prepaid</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="icheck-primary">
                                                <input type="checkbox" name="is_partial" value="1" id="is_partial" />
                                                <label for="air_status">Partal</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Image</i></legend>
                                <div class="form-group" style="display: none;">
                                    <label for="input-1">Image Cdn Link</label>
                                    <textarea type="text" class="form-control" name="image_path" placeholder="Image Cdn Link"></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Image cdn Link.
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="input-1">Choose Multiple Images *</label>
                                    <input type="file" multiple="multiple" class="form-control" name="image[]" accept=".png,.jpg,.jpeg,.gif" />
                                </div>
                            </fieldset>
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Other info.</i></legend>
                                <div class="form-group">
                                    <label for="input-1">Total Inventory</label>
                                    <input type="number" class="form-control" min="1" name="in_stock" placeholder="Total Inventory *" required />
                                    <div class="invalid-feedback">
                                        Please Enter Inventory.
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="input-3">Status</label>
                                    <select name="is_active" required class="form-control">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </fieldset>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary shadow-primary px-5 pull-right" name="submit" value="Save">Save</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    @endsection
    <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
    <script>
        window.onload = function () {
            CKEDITOR.replace("description");
            setTimeout(CKEDITOR.instances.description.resize(300, 400), 300);
        };
    </script>
<script>
  function productSlug(val)
  {   
    var slugname = val.toLowerCase().trim();
    var slug_name = slugname.replace(/ /g,"-");
    var slug_name1 = slug_name.replace(/([.*+%?^=!:${}&'()|\[\]\/\\#])/g,"");
    document.getElementById("meta_title").value = ''+val; 
  

  //alert(slug_name);
}

</script>


