@extends('theme.layouts.app') @section('content')

<style type="text/css">
    fieldset.scheduler-border {
        border: 1px groove #ddd !important;

        padding: 0 1.4em 1.4em 1.4em !important;

        margin: 0 0 1.5em 0 !important;

        -webkit-box-shadow: 0px 0px 0px 0px #000;

        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border {
        font-size: 1.2em !important;

        font-weight: bold !important;

        text-align: left !important;

        width: auto;

        padding: 0 10px;

        border-bottom: none;
    }
</style>

<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">CMS</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Slider</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                    <h4 class="page-title">Edit Slider</h4>
                </div>
            </div>
        </div>

        <form class="needs-validation parsley-examples" data-parsley-validate action="{{route('slider.update',$rows->id)}}" method="POST" enctype="multipart/form-data" novalidate>
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                                <div class="form-group">
                                    <label for="input-1">Heading*</label>
                                    <input type="text" class="form-control" name="name" value="{{ $rows->name }}" required />
                                    <div class="invalid-feedback">
                                        Please Enter Heading.
                                    </div>
                                </div>
                               <div class="form-group">
                                    <label for="input-1">External url *</label>
                                    <textarea class="form-control" name="slug" placeholder="External Link *" required>{{ $rows->slug }}</textarea>
                                    <div class="invalid-feedback">
                                        Please Enter External url.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Description</label>
                                    <textarea type="text" class="form-control" name="description" id="description" placeholder="Description" required>{{ $rows->description }}</textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Description.
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Files</i></legend>
                                <div class="form-group">
                                    <input type="hidden" name="old_upload_banner" value="{{$rows->upload_banner}}" />
                                    <img src="{{ url('public/storage/slider/'.$rows->upload_banner) }}" width="120">
                                </div>

                                <div class="form-group">
                                    <label for="input-1">Image File</label>
                                    <input type="file" class="form-control" name="upload_banner" accept=".jpg,.jpeg,.png" />
                                    <div class="invalid-feedback">
                                        Please Upload Banner.
                                    </div>
                                </div>

                            </fieldset>
                                <fieldset class="scheduler-border">
                                    <legend align="left" class="scheduler-border"><i>Other info.</i></legend>
                                 <div class="form-group">
                                    <label for="input-3">Upload Type</label>
                                    <select name="upload_type" required class="form-control">
                                        <option value="slider" @if($rows->upload_type=='slider'){{ "selected" }}@endif>Slider</option>
                                        <option value="slider_bottom" @if($rows->upload_type=='slider_bottom'){{ "selected" }}@endif>Slider Bottom</option>

                                        <option value="slider_footer" @if($rows->upload_type=='slider_footer'){{ "selected" }}@endif>Slider Footer</option>
                                        <option value="slider_footer_top" @if($rows->upload_type=='slider_footer_top'){{ "selected" }}@endif>Slider Footer Top</option>
                                        <option value="slider_footer_top_1" @if($rows->upload_type=='slider_footer_top_1'){{ "selected" }}@endif>Slider Footer Top 1</option>
                                        <option value="slider_footer_top_2" @if($rows->upload_type=='slider_footer_top_2'){{ "selected" }}@endif>Slider Footer Top 2</option>
                                        <option value="slider_footer_top_3" @if($rows->upload_type=='slider_footer_top_3'){{ "selected" }}@endif>Slider Footer Top 3</option>

                                        <option value="slider_content" @if($rows->upload_type=='slider_content'){{ "selected" }}@endif>Content</option>

                                        <option value="client" @if($rows->upload_type=='client'){{ "selected" }}@endif>Client Slider</option>

                                    </select>
                                </div>
                                    <div class="form-group">
                                        <label for="input-3">Status</label>
                                        <select name="is_active" required class="form-control">
                                            <option value="1" @if($rows->is_active==1){{ "checked" }}@endif>Active</option>
                                            <option value="0" @if($rows->is_active==0){{ "checked" }}@endif>Inactive</option>
                                        </select>
                                    </div>
                                </fieldset>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary shadow-primary px-5 pull-right" name="submit" value="Save">Save</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
    <script>
        window.onload = function () {
            CKEDITOR.replace("description");
            setTimeout(CKEDITOR.instances.description.resize(300, 400), 300);
        };
    </script>
<script>
  function productSlug(val)
  {   
    var slugname = val.toLowerCase().trim();
    var slug_name = slugname.replace(/ /g,"-");
    var slug_name1 = slug_name.replace(/([.*+%?^=!:${}&'()|\[\]\/\\#])/g,"");
    document.getElementById("meta_title").value = ''+val; 
  //alert(slug_name);
}
</script>
@endsection
