@extends('theme.layouts.app') 
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                        </ol>
                    </div>
                    <h4 class="page-title">Edit Companies</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border">
                                Edit Company
                            </legend>
                            <form action="{{ route('company.update',$rows->id) }}" method="POST" class="parsley-examples" data-parsley-validate style="text-transform: uppercase;" novalidate>
                              @csrf
                              @method('PUT')
                              <input type="hidden" name="user_id" value="{{ Auth::id() }}">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="Company Name">Company Name <span class="text-danger">*</span></label>
                                            <input type="text" name="name" value="{{ $rows->name }}" parsley-trigger="change" required placeholder="ENTER COMPANY NAME *" class="form-control" id="name"  />
                                            @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="form-group">
                                            <label for="address">Address<span class="text-danger">*</span></label>
                                            <textarea name="address" parsley-trigger="change" required placeholder="COMPANY ADDRESS*" rows="5" class="form-control" id="address">{{ $rows->address }}</textarea>
                                            @error('address')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="gstin">GSTIN<span class="text-danger">*</span></label>
                                            <input id="gst" name="gst" type="text" value="{{ $rows->gst }}" style="text-transform: uppercase;" placeholder="Company GST Number *" required class="form-control" />
                                            @error('gst')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="form-group">
                                            <label for="pan">PAN<span class="text-danger">*</span></label>
                                            <input id="pan" type="text" name="pan" placeholder="Company PAN Number *" style="text-transform: uppercase;" value="{{ $rows->pan }}" required class="form-control" />
                                            @error('pan')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="form-group">
                                            <label for="is_active">Status<span class="text-danger">*</span></label>
                                            <select name="is_active" class="form-control" required="required">
                                              <option value="1" @if($rows->is_active==1){{ 'selected' }} @endif>ACTIVE</option>
                                              <option value="0" @if($rows->is_active==0){{ 'selected' }} @endif>INACTIVE</option>
                                            </select>  
                                        </div>
                                        <div class="form-group text-right mb-0">
                                            <button class="btn btn-primary waves-effect waves-light mr-1" type="submit" name="submit" value="Save">
                                                SAVE
                                            </button>
                                            <button type="reset" onclick="history.back();" class="btn btn-secondary waves-effect">
                                                CANCEL
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </div>
    <!-- end container-fluid -->
</div>
@endsection
