@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                  </ol>
               </div>
               <h4 class="page-title">Companies</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->
      <div class="row">
         <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
               <div class="card-body">
                  <fieldset class="scheduler-border">
                     <legend align="left" class="scheduler-border">
                        {{ $inv_count }} - TOTAL
                     </legend>
                     <form method="get" action="{{ route('invoice.bulk') }}">
                        <div class="btn-group btn-group-sm" role="group">
                           <input type="text" class="form-control form-control-sm" style="width: 420px;" name="daterange" id="reportrange" onclick="daterange(start,end)" placeholder="Search By YYYY-MM-DD" />
                           <button type="submit" class="btn btn-primary btn-sm has-icon"><i class="mr-1 fa fa-search"></i> Search</button>      
                           &nbsp;
                           <a href="javascript:void(0);" title="Import Orders" class="btn btn-light" data-toggle="modal" data-target="#uploadModal"><i class="fa fa-upload"></i> Upload</a>
                        </div>
                     </form>
                     <div class="table-responsive mt-3">
                        <table class="table table-striped table-sm">
                           <thead class="text-left thead-primary">
                              <tr align="left">
                                 <th>Invoice_Date</th>
                                 <th>Total</th>
                                 <th>Action</th>
                              </tr>
                           </thead>
                           <tbody>
                              @foreach($response as $key=>$rows)
                              <form action="" id="logout-form{{ $key+1 }}" method="post">
                                 @csrf
                                 <tr align="left">
                                 <td>{{ date('d M, Y',strtotime($rows->invoice_date)) }}</td>
                                 <td><b>{{ $rows->total }}</b></td>
                                 <td>
                                 @if(Request::has('daterange'))
                                 <a href="{{ url('/admin/print-invoice/download/'.$rows->invoice_date.'/'.base64_encode(Request::get('daterange')).'/'.$rows->total) }}" title="Download Label" class="badge badge-danger text-white"><i class="fa fa-file-pdf-o"></i> Print Invoice</a>

                                 <a href="{{ url('/admin/print-invoice/excel/'.$rows->invoice_date.'?daterange='.Request::get('daterange').'&count='.$rows->total) }}" title="Excel" class="badge badge-success text-white"><i class="fa fa-file-excel-o"></i> Excel</a>
                                 @elseif(Request::has('custom_search'))

                                 <a href="{{ route('invoice.download',[$rows->invoice_date,'custom_search'=>request()->custom_search,'daterange'=>request()->daterange,'count'=>$rows->total]) }}" title="Download Label" class="badge badge-danger text-white"><i class="fa fa-pdf-o"></i> Print Invoice</a>

                                 <a href="{{ route('excel.download',[$rows->invoice_date,'custom_search'=>request()->custom_search,'daterange'=>request()->daterange,'count'=>$rows->total]) }}" title="Download Excel" class="badge badge-success text-white"><i class="fa fa-file-excel-o"></i> Excel</a>
                                 @else
                                 <a href="{{ route('invoice.download',[$rows->invoice_date,'custom_search'=>request()->custom_search,'daterange'=>request()->daterange,'count'=>$rows->total]) }}" title="Download Label" class="badge badge-danger text-white"><i class="fa fa-file-pdf-o"></i> Print Invoice</a>

                                 <a href="{{ route('excel.download',[$rows->invoice_date,'custom_search'=>request()->custom_search,'daterange'=>request()->daterange,'count'=>$rows->total]) }}" title="Download" class="badge badge-success text-white"><i class="fa fa-excel-o"></i> Excel</a>

                                 @endif

                                 </td>   
                                </tr>
                              </form>
                              @endforeach
                           </tbody>
                        </table>
                        {!! $response->links() !!}
                     </div>
                  </fieldset>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>

   <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="basicModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
         <div class="modal-content">
            <div class="modal-header">
               <div class="col-lg-12 col-md-12 col-sm-12">
                  <div class="card-content">
                     <fieldset class="scheduler-border">
                        <legend align="left" class="scheduler-border"><b style="font-size: 18px;">UPLOAD ORDER</b>&nbsp;<a href="{{ url('storage/csv/format/INVOICE.csv') }}" title="Download Format" download="" style="font-size: 11px;"><i class="fa fa-download"></i> format</a></legend>
                        <form method="post" action="{{route('invoice.bulk.upload') }}" enctype="multipart/form-data"> @csrf <div class="row">
                              <div class="col-md-12">
                                 <div class="form-group"><input type="file" name="uploadfile" class="form-control" required="" /></div><button type="submit" style="font-size: 18px;" class="btn btn-info btn-sm shadow-primary btn-block" name="submit" value="Upload"><i class="fa fa-upload"></i> Upload</button>
                              </div>
                           </div>
                        </form>
                     </fieldset>
                  </div>
               </div><button type="button" class="close" style="margin-left: -35px;margin-top: -30px;font-weight: bold;" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
         </div>
      </div>
   </div>


   <!-- end container-fluid -->
</div>
@endsection