@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">

                  <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                  </ol>

                    </div>
                    <h4 class="page-title">{{ $rows->order_no }}</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

<div class="row">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Track Order</h4>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="mb-4">
                            <h5 class="mt-0">Order ID: #{{ $rows->order_no }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Items from Order #{{ $rows->order_no }}</h4>

                <div class="table-responsive">
                    <table class="table table-bordered table-centered mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Product name</th>
                                <th>Product</th>
                                <th>Quantity</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">{{ $rows->product }}</th>
                                <td><img src="{{ $rows->image }}" alt="product-img" height="32" /></td>
                                <td>{{ $rows->quantity }}</td>
                                <td><i class="fa fa-inr"></i>{{ $rows->subtotal_price }}</td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="3" class="text-right">Total :</th>
                                <td><div class="font-weight-bold"><i class="fa fa-inr"></i>{{ $rows->amount }}</div></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Shipping Information</h4>

                <h5 class="font-family-primary font-weight-semibold">{{ $rows->name }}</h5>

                <p class="mb-2"><span class="font-weight-semibold mr-2">Address:</span> {{ $rows->address }}, {{ $rows->city }}, {{ $rows->state }} - {{ $rows->pincode }}</p>
                <p class="mb-2"><span class="font-weight-semibold mr-2">Phone:</span> {{ $rows->mobile }}</p>
                <p class="mb-0"><span class="font-weight-semibold mr-2">Email:</span> {{ $rows->email }}</p>
            </div>
        </div>
    </div>
    <!-- end col -->

    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Billing Information</h4>

                <ul class="list-unstyled mb-0">
                    <li>
                        <p class="mb-2"><span class="font-weight-semibold mr-2">Payment Method:</span> <b>{{ strtoupper($rows->payment_mode) }}</b></p>
                        <p class="mb-2"><span class="font-weight-semibold mr-2">Order_id:</span> #<b>{{ $rows->order_id }}</b></p>
                        <p class="mb-2"><span class="font-weight-semibold mr-2">Order Date:</span> {{ date('d M, Y',strtotime($rows->order_date)) }}</p>

                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- end col -->
    <div class="col-lg-4" style="display: none;">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Delivery Info</h4>

                <div class="text-center">
                    <i class="mdi mdi-truck-fast h2 text-muted"></i>
                    <p class="mb-1"><span class="font-weight-semibold">2293893893</p>
                    <p class="mb-0"><span class="font-weight-semibold">EcomExpress</span></p>
                </div>
            </div>
        </div>
    </div>
    <!-- end col -->
</div>


        <!-- end row -->
    </div> <!-- end container-fluid -->
</div>

@endsection
