<?php

error_reporting(0);

use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::any('/trackdata',[App\Http\Controllers\Store\PageController::class,'trackdata'])->name('trackdata');


Route::get('/awards', [App\Http\Controllers\Store\PageController::class, 'awards'])->name('awards');
Route::get('/pdf', [App\Http\Controllers\Store\CheckoutController::class, 'convert_pdf_to_image']);
Route::get('/', [App\Http\Controllers\Store\HomeController::class, 'index'])->name('store.home');

Route::get('/services', [App\Http\Controllers\Store\PageController::class, 'services'])->name('services');
Route::get('/services/{slug}', [App\Http\Controllers\Store\PageController::class, 'services_details'])->name('services.details');

Route::get('/blog', [App\Http\Controllers\Store\PageController::class, 'blog'])->name('blog');
Route::get('/blog/{slug}', [App\Http\Controllers\Store\PageController::class, 'blog_details'])->name('blog.details');

Route::post('/demo', [App\Http\Controllers\Store\PageController::class, 'demo'])->name('demo');



Route::get('/search', [App\Http\Controllers\Store\HomeController::class, 'fetch_search_products'])->name('store.search');
Route::get('/collections/{slug}', [App\Http\Controllers\Store\HomeController::class, 'index'])->name('store.collections');
Route::get('/ajax-more', [App\Http\Controllers\Store\HomeController::class, 'ajax_load_more'])->name('store.ajax-more');
Route::get('/products/{slug}', [App\Http\Controllers\Store\HomeController::class, 'fetch_single_products'])->name('store.fetch-single-pro');


Route::any('/contact-us', [App\Http\Controllers\Store\PageController::class, 'contact_us'])->name('contact_us');
Route::group(['prefix' => 'pages'], function() {
	Route::get('/{slug}', [App\Http\Controllers\Store\PageController::class, 'index'])->name('store.pages');
});


Route::group(['prefix' => 'admin'], function() 
{

	Auth::routes(['register' => false]);
	Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
	Route::get('/demo', [App\Http\Controllers\HomeController::class, 'demo'])->name('admin.home');

	
	Route::group(['prefix' => 'inventory'], function() {
		Route::get('prorducts',[App\Http\Controllers\ProductController::class,'fetch_all_shopify_products'])->name('fetch-all-shopify-products');
		Route::resource('collection','App\Http\Controllers\CollectionController');
		Route::resource('product','App\Http\Controllers\ProductController');
		Route::get('ajax-update-images',[App\Http\Controllers\ProductController::class,'ajax_update_images'])->name('ajax-update-images');
		Route::get('ajax-remove-images',[App\Http\Controllers\ProductController::class,'ajax_remove_images'])->name('ajax-remove-images');
		Route::resource('review','App\Http\Controllers\ReviewController');

	});
	Route::resource('services','App\Http\Controllers\ServiceController');

	Route::group(['prefix' => 'cms'], function() {
		Route::resource('pages','App\Http\Controllers\PageController');
		Route::resource('slider','App\Http\Controllers\SliderController');
		Route::resource('testimonial','App\Http\Controllers\TestiController');


		
	});
	Route::group(['prefix' => 'settings'], function() {

		Route::resource('site','App\Http\Controllers\SiteController');
		Route::resource('integration','App\Http\Controllers\IntegrationController');
		
		    Route::resource('warehouse','App\Http\Controllers\WarehouseController');
		    Route::get('/warehouse/status/{id}', [App\Http\Controllers\WarehouseController::class,'Status'])->name('warehouse.status');
		    Route::resource('servicable', 'App\Http\Controllers\ServicableController');
			Route::get('/servicable/active/{id}', [App\Http\Controllers\ServicableController::class,'ActiveStatus'])->name('servicable.active.status');
			Route::get('/servicable/all/export', [App\Http\Controllers\ServicableController::class,'Export'])->name('servicable.export');


			Route::get('/api', [App\Http\Controllers\Api\WebhookController::class,'apis_response'])->name('api.index');
			Route::post('/api-update', [App\Http\Controllers\Api\WebhookController::class,'apis_update'])->name('api.update');
			Route::get('/api-action', [App\Http\Controllers\Api\WebhookController::class,'apis_active_update'])->name('api.action');

			Route::get('/api-webhook', [App\Http\Controllers\Api\WebhookController::class,'apis_webhook_update'])->name('api.webhook');




		    // Route::get('api',function()
		    // {
			   //    return view('theme.api.api');	
		    // })->name('api.index');
	});
   



});


	Route::group(['prefix' => 'support'], function() {
		Route::get('/',[App\Http\Controllers\Support\SupportController::class,'support_form']);
	});
