<?php $__env->startSection('content'); ?>
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <form method="get" action="<?php echo e(route('fetch-all-orders')); ?>">
                            <div class="btn-group btn-group-sm" role="group">
                                <input type="text" class="form-control form-control-sm" style="width: 320px;" name="custom_search" placeholder="Search Order Id">&nbsp;&nbsp;
                                <input type="text" value="<?php echo e(Request::get('daterange')); ?>" class="form-control form-control-sm" style="width: 320px;" name="daterange" id="reportrange" onclick="daterange(start,end)" placeholder="Search By YYYY-MM-DD">
                                <button type="submit" class="btn btn-primary btn-sm has-icon"><i class="fa fa-search"></i> search</button>        
                            </div>
                        </form>
                    </div>
                    <h4 class="page-title"><?php echo e($all_result->total()); ?> Orders</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-xl-12">
                <div class="card-box">
                    <h4 class="header-title mb-3">Recently Orders</h4>
                                            <table class="table table-centered table-nowrap mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th style="width: 20px;">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                                                <label class="custom-control-label" for="customCheck1">&nbsp;</label>
                                                            </div>
                                                        </th>
                                                        <th>Order ID</th>
                                                        <th>Products</th>
                                                        <th>Date</th>
                                                        <th>Payment Status</th>
                                                        <th>Total</th>
                                                        <th>Order Status</th>
                                                        <th>Calling Status</th>
                                                        <th style="width: 125px;">Action</th>
                                                    </tr>
                                                </thead>
                            <tbody>
                          <?php $__currentLoopData = $all_result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>      
                            <tr>
                                <td>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="customCheck2">
                                        <label class="custom-control-label" for="customCheck2">&nbsp;</label>
                                    </div>
                                </td>
                                <td><b class="text-body font-weight-bold">#<?php echo e($rows->order_no); ?></b></td>
                                <td><img src="<?php echo e($rows->src); ?>" height="40" width="40" /></td>
                                <td><?php echo e(Helper::ParseTime($rows->created_at)); ?></td>
                                <td><?php if($rows->pmode=='PREPAID'): ?>
                                    <span class="badge badge-success">PREPAID</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">CASH ON DELIVERY</span>
                                    <?php endif; ?>
                                </td>
                                <td><i class="fa fa-inr"></i> <?php echo e(number_format($rows->amount,2)); ?></td>
                                <td><?php if($rows->pmode=='PREPAID'): ?>
                                    <span class="badge badge-info">Shipped</span>
                                    <?php else: ?>
                                    <span class="badge badge-warning">Processing</span>
                                    <?php endif; ?>
                                </td>
                                <td><b class="text-body badge badge-success text-white font-weight-bold">Confirmed</b></td>
                                <td><a href="<?php echo e(route('fetch-single-orders',encrypt($rows->id))); ?>" title="Get More Details" class="btn btn-sm btn-secondary"><i class="fa fa-eye"></i> View Details</a></td>
                            </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>      
                            </tbody>
                        </table>
                    </div>
                </div>
                    <?php echo $__env->make('theme.layouts.pagination', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div><!-- end col-->

        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\php8.2\htdocs\advance\cmsweb\resources\views/theme/orders/fetch_all_orders.blade.php ENDPATH**/ ?>