<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Models\Slider;

class SliderController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {

        $result = Slider::whereUser_id(Auth::id())
                              ->latest()
                              ->paginate(16);
        return view('theme.cms.slider.index',['response'=>$result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'CMS / Add Page']; 
        return view('theme.cms.slider.add',['breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->submit=='Save' && $request->isMethod('post') && $request->has('submit'))
        {

            $request->validate(['name'=>'required']);

            if ($request->hasFile('upload_banner')) 
            {

                $image      = $request->file('upload_banner'); 
                $upload_banner = Str::slug($request->name,'-').'-'.rand(11111,9999).'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/storage/slider');
                $image->move($destinationPath, $upload_banner);
                $src = url('/public/storage/slider/'.$upload_banner);
            }else{
                $upload_banner = 'N/A';
            }    

            $fillable_slider_data = ['user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                         'slug' =>$request->slug,
                                         'description' =>$request->description,
                                         'upload_banner' =>$upload_banner,
                                         'upload_type' =>$request->upload_type,
                                         'is_active'=>$request->is_active,
                                         'created_at'=>date('Y-m-d H:i:s')];
            Slider::insert($fillable_slider_data);                             
            return redirect()->route('slider.index')->with('message','Banner Created Successful.');
        }else{
            return redirect()->route('slider.index')->with('error','Invalid Arguments!');
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        if($request->has('action') && $request->action==0)
        {
           Slider::where('id',$id)->update(['is_active'=>0]);
           return redirect()->route('pages.index')->with('error','Slider Inactivated Successful.');
        } if($request->has('action') && $request->action==1){
           Slider::where('id',$id)->update(['is_active'=>1]);
           return redirect()->route('slider.index')->with('success','Slider Activated Successful.');
        }
        $response = Slider::findOrFail($id);
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'CMS / Edit Slider']; 
        return view('theme.cms.slider.edit',['breadcrumbs'=>$breadcrumbs,'rows'=>$response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->submit=='Save' && $request->isMethod('put') && $request->has('submit'))
        {
            $request->validate(['name'=>'required']);
            if ($request->hasFile('upload_banner')) 
            {

                $image      = $request->file('upload_banner'); 
                $upload_banner = Str::slug($request->name,'-').'-'.rand(11111,9999).'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/storage/slider');
                $image->move($destinationPath, $upload_banner);
                $src = url('/public/storage/slider/'.$upload_banner);
            }else{
                $upload_banner = $request->old_upload_banner;
            }    

            $fillable_slider_data = ['user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                         'slug' =>$request->slug,
                                         'description' =>$request->description,
                                         'upload_banner' =>$upload_banner,
                                         'upload_type' =>$request->upload_type,
                                         'is_active'=>$request->is_active,
                                         'created_at'=>date('Y-m-d H:i:s')];
            Slider::whereId($id)->update($fillable_slider_data);                             
            return redirect()->route('slider.index')->with('message','Page Saved Successful.');
        }else{
                return redirect()->route('slider.index')->with('error','Invalid Arguments!');
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Slider::where('id',$id)->delete();
        return redirect()->route('slider.index')->with('error','Slider Deleted Successful.');
    }
}
