<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\Warehouse;

class WarehouseController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        $result = Warehouse::latest()
                           ->paginate(10);
        return view('theme.warehouse.index')->with(['response'=>$result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('theme.warehouse.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->isMethod('post') && $request->has('submit') && $request->submit=='Save')
        {
            $this->validate($request, [
                                        'name'           => 'required|max:320',
                                        'contact_name'   => 'required',
                                        'address_1'      => 'required',
                                        'address_2'      => 'required',
                                        'city'           => 'required',
                                        'state'          => 'required',
                                        'pincode'        => 'required',
                                        'email'          => 'required|email',
                                        'mobile'         => 'required|unique:warehouses'
                                    ]);

            $data['user_id']      = Auth::user()->id;
            $data['name']         = $request->name;
            $data['contact_name'] = $request->contact_name;
            $data['address_1']    = $request->address_1;
            $data['address_2']    = $request->address_2;
            $data['city']         = $request->city;
            $data['state']        = $request->state;
            $data['pincode']       = $request->pincode;
            $data['email']        = $request->email;
            $data['mobile']       = $request->mobile;
            $data['is_active']    = 1;
            Warehouse::create($data);
            return redirect()->route('warehouse.index')->with('message','Warehouse Created Successful.');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $response = Warehouse::findOrFail($id);
        return view('theme.warehouse.edit',['rows'=>$response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->submit=='Save' && $request->isMethod('put') && $request->has('submit'))
        {
            $this->validate($request, [
                                        'name'           => 'required|max:320',
                                        'contact_name'   => 'required',
                                        'address_1'      => 'required',
                                        'address_2'      => 'required',
                                        'city'           => 'required',
                                        'state'          => 'required',
                                        'pincode'        => 'required',
                                        'email'          => 'required|email',
                                        'mobile'         => 'required|unique:warehouses'
                                    ]);

            $data['user_id']      = Auth::user()->id;
            $data['name']         = $request->name;
            $data['contact_name'] = $request->contact_name;
            $data['address_1']    = $request->address_1;
            $data['address_2']    = $request->address_2;
            $data['city']         = $request->city;
            $data['state']        = $request->state;
            $data['pincode']       = $request->pincode;
            $data['email']        = $request->email;
            $data['mobile']       = $request->mobile;
            $data['is_active']    = 1;
            Warehouse::whereId($id)->update($data);
        }    
            return redirect()->route('warehouse.index')->with('message','Warehouse Updated Successful.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $rows = Warehouse::findOrFail($id);
        $rows->delete();
        return redirect()->route('warehouse.index')->with('error','Warehouse Deleted Successful.');
    }


   /**
    
        * Active Status Pincode wise

   */ 
    public function Status(Request $request ,$id)
    {   
        $pincode_rows = Warehouse::findOrFail($id);
        $pincode_rows->is_active = $request->action;
        $pincode_rows->save();             
        if($request->action==0)
        {
            Session::flash('error','Warehouse Inactivated Successful.');
        }else{
            Session::flash('info','Warehouse Activated Successful.');
        }    
        return redirect()->route('warehouse.index');
    }



}
