<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreign('user_id')->references('id')->on('users');           
            $table->tinyInteger('is_ship')->default(0);
            $table->tinyInteger('is_sms')->default(0);
            $table->tinyInteger('is_call')->default(0);
            $table->tinyInteger('is_mail')->default(0);
            $table->tinyInteger('is_order')->default(0);
            $table->tinyInteger('is_account')->default(0);
            $table->timestamps();
            $table->index('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
