<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buy_whatsapps', function (Blueprint $table) {
            $table->id();
            $table->text('name');
            $table->string('email');
            $table->string('mobile');
            $table->text('product');
            $table->string('quantity');
            $table->text('address');
            $table->string('city');
            $table->string('state');
            $table->string('pincode');
            $table->tinyInteger('is_status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapps');
    }
}
