<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderTokensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('backup_id');
            $table->foreign('backup_id')->references('id')->on('backups'); 
            $table->string('order_no')->unique();
            $table->string('__token')->unique();
            $table->tinyInteger('is_active')->default(0);
            $table->timestamps();
            $table->index('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_tokens');
    }
}
