@php
    $rows = App\Models\Backup::whereId(Session::get('oid'))->first();
@endphp
<div style="font-family:Arial,Helvetica,sans-serif;font-size:12px;color:#000000">
  <div style="width:680px">
    <p style="margin-top:0px;margin-bottom:20px">Thank you for your interest in <b>{{config('app.name')}}</b> products. Your order has been received and will be processed once payment has been confirmed.</p>
    <table style="border-collapse:collapse;width:100%;border-top:1px solid #dddddd;border-left:1px solid #dddddd;margin-bottom:20px">
      <thead>
        <tr>
          <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:left;padding:7px;color:#222222" colspan="2">Order Details</td>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:left;padding:7px"><b>Order ID:</b> {{ Session::get('order_id') }}<br>
            <b>Date Added:</b> {{date('d M Y')}}<br>
            <b>Payment Method:</b> {{ $rows->payment_mode }}<br>
            <b>Shipping Method:</b> Per Item Shipping Rate </td>
            <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:left;padding:7px"><b>E-mail:</b> <a href="mailto:{{session()->get('email')}}" target="_blank">{{session()->get('email')}}</a><br>
              <b>Telephone:</b> {{ Session::get('mobile') }}<br>
              <b>Order Status:</b> Pending<br></td>
            </tr>
          </tbody>
        </table>
        <table style="border-collapse:collapse;width:100%;border-top:1px solid #dddddd;border-left:1px solid #dddddd;margin-bottom:20px">
          <thead>
            <tr>
              <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:left;padding:7px;color:#222222">Payment Address</td>
              <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:left;padding:7px;color:#222222">Shipping Address</td>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:left;padding:7px">
                {{ $rows->name }}<br>
                {{ $rows->address }}<br>
                {{ $rows->city }}, {{ $rows->state }} Pincode - {{ $rows->pincode }}<br>India</td>
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:left;padding:7px">
                {{ $rows->name }}<br>
                {{ $rows->address }}<br>
                {{ $rows->city }}, {{ $rows->state }} Pincode - {{ $rows->pincode }}<br>India</td>
               </tr>
              </tbody>
            </table>
           <table style="border-collapse:collapse;width:100%;border-top:1px solid #dddddd;border-left:1px solid #dddddd;margin-bottom:20px">
              <thead>
                <tr>
                  <td colspan="2" style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:left;padding:7px;color:#222222">Product</td>
                  <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:right;padding:7px;color:#222222">Quantity</td>
                  <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:right;padding:7px;color:#222222">Price</td>
                  <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;background-color:#efefef;font-weight:bold;text-align:right;padding:7px;color:#222222">Total</td>
                </tr>
              </thead>
              <tbody>

                <tr>
                 <td colspan="2" style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:left;padding:7px">{{ $rows->product }} </td>
                 <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">{{ '1' }}</td>
                 <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">Rs {{ number_format($rows->subtotal_price,2)}}</td>
                 <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">Rs {{ number_format($rows->subtotal_price,2) }}</td>
               </tr>

             </tbody>
             <tfoot>
              <tr>
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px" colspan="4"><b>Shipping Charge:</b></td>
                @if($rows->shipping_amount==0)
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">Free</td>
                @else
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">Rs {{ $rows->shipping_amount }}</td>

                @endif
              </tr>
              <tr>
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px" colspan="4"><b>Total:</b></td>
                <td style="font-size:12px;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;text-align:right;padding:7px">Rs {{ number_format(Session::get('amount'),2) }}</td>
              </tr>
              <tr>
                <td colspan="5"><div height="50" width="320"></div></td>
              </tr>
            </tfoot>
          </table>
          <p align="center" style="margin-top:0px;margin-bottom:20px">Please reply to this e-mail if you have any questions.</p>
        </div>
      </div>
