  <div class="modal fade modal-content-right modal-cart" id="cartModal" tabindex="-1" role="dialog" aria-labelledby="cartModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
      <div class="modal-content">
        <div class="modal-header border-bottom">
          <h5 class="modal-title" id="cartModalLabel">You have {{ Cart::count()}} items in your cart</h5>
          <button class="btn btn-icon btn-sm btn-text-secondary rounded-circle" type="button" data-dismiss="modal">
            <i class="material-icons">close</i>
          </button>
        </div>
        <div class="modal-body scrollbar-width-thin">
          <ul class="list-group list-group-flush">
              @foreach(Cart::content() as $cart_key=>$cart_rows)
              <li class="list-group-item px-0">
                <div class="media">
                  <a href="{{route('store.fetch-single-pro',$cart_rows->options->slug)}}" class="mr-2"><img src="{{ $cart_rows->options->image }}" width="50" height="50" alt="{{ $cart_rows->title }}"></a>
                  <div class="media-body">
                    <a href="{{route('store.fetch-single-pro',$cart_rows->options->slug)}}">{{ $cart_rows->title }}</a>
                    <em class="text-muted">{{ $cart_rows->quantity }} x <span class="price"><i class="fa fa-inr"></i> {{ $cart_rows->price }}</span></em>
                  </div>
                  <button class="btn btn-icon btn-sm btn-text-danger rounded-circle" onclick="window.location='{{ route('cart-remove',$cart_rows->rowId) }}'" title="Remove From Cart" type="button"><i class="material-icons">close</i></button>
                </div>
              </li>
              @endforeach
          </ul>

        </div>
        <div class="modal-footer border-top">
          <div class="mr-auto">
            <em>Subtotal</em>
            <h5 class="mb-0 text-dark font-weight-bold font-condensed"><span class="price"><i class="fa fa-inr"></i> {{ Cart::subtotal() }}</h5>
          </div>
          <a href="{{ url('checkout/cart') }}" class="btn btn-faded-success">View Cart</a>
          <a href="{{ url('checkout/valid-otp') }}" class="btn btn-success">Checkout</a>
        </div>
      </div>
    </div>
  </div>
