<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Search Products {{ ucwords(str_replace('-',' ',request()->get('q'))) }} | {{ ucfirst(substr (Request::root(), 11)) }}</title>
        <meta name="Description" content="India's Best Online store for Mobiles, Mobile Accessories, Electronics, and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card "/>
        <meta name="Keywords" content="Online Shopping in India,online Shopping store,Online Shopping Site,Buy Online,Shop Online,Online Shopping {{ config('app.name') }}" />
        <meta name='og:description' content="India&#x27;s Largest online store for Mobiles, Fashion , Electronics, Home Appliances, Books, Jewelry, Home, Furniture, Sporting goods, Beauty &amp; Personal Care, Grocery and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card &amp; more.">
        <meta property="og:type" content="website" />
        <meta name="og_site_name" property="og:site_name" content="{{ config('app.name') }}" />
        <meta property="og:image" itemprop="image primaryImageOfPage" content="{{ asset('storefront/images/icon.png')}}" />
        <meta name="og:title" content="Online Shopping Site for Mobiles, Electronics, Books &amp; More. Best Offers!">
        <meta name='og:description' content="India&#x27;s Largest online store for Mobiles, Fashion , Electronics, Home Appliances, Books, Jewelry, Home, Furniture, Sporting goods, Beauty &amp; Personal Care, Grocery and more! Find the largest selection from all brands at the lowest prices in India. Payment options - COD, EMI, Credit card, Debit card &amp; more.">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta name="facebook-domain-verification" content="bom2pnbnef3m6majpxaeegsy0968uf" />
        <link rel="icon" href="{{ asset('storefront/images/icon.png')}}" type="image/png" />
        <meta property="og:url" content="{{ url('/') }}" />
        <link rel="canonical" href="{{ url('/') }}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/materializeCss.css')}}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/bootstrapCss.css')}}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/viewportCss.css')}}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/customStyles.css')}}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/swiperCss.css')}}" />
        <link rel="preload" as="style" onload="this.rel='stylesheet'" href="{{ asset('storefront/mobile/customCssV16.css')}}" />
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="prefetch" as="style" onload="this.rel='stylesheet'" />
        <link href="{{ asset('storefront/mobile/Styles/jquery-ui.css')}}" rel="preload" as="style" onload="this.rel='stylesheet'" />
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/mobilejqueryJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/mobilejqueryUiJs.js')}}"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="{{ asset('storefront/mobile/Js/enhancedecommerce.js')}}"></script>
    </head>
    <body>
        @include('storefront.partials.loader')
        <!--o-wrapper  Start-->
        <div id="o-wrapper" class="o-wrapper">
            <!--TopHeader // Start-->
            @include('storefront.partials.header')
            <div id="SearchAutocompleteDiv" class="FilterLists" style="display: none;"></div>
            <div id="dvContainer">
                <div id="bodyContainer">
                    <section class="CategorySection fullWidth white_back">
                      @if(count($response)>0)
                        <div class="ProductsDisplayArea grid_view">
                            <div class="container">
                              <center>  
                                <div class="filter">
                                    <center><h1><b>Search:</b> {{ Request::get('searchkeyword') }}</h1></center>
                                </div>
                            </center>
                                <ul class="ProductsDisplayAreaUL">
                                  @foreach($response as $key=>$rows)
                                    <li itemscope="" itemtype="http://schema.org/Product" onclick="window.open({{ route('store.fetch-single-pro',$rows->slug) }},'_blank')" title="{{$rows->name}}">
                                        <a href="{{ route('store.fetch-single-pro',$rows->slug) }}" target="_blank" title="{{$rows->name}}">
                                            <div class="product_img">
                                                <picture>
                                                    <source
                                                        type="image/webp"
                                                        media="(min-width: 320px)"
                                                        srcset="{{ $rows->image }}"
                                                        alt="{{ $rows->name }}"
                                                    />
                                                    <img src="{{ $rows->image }}" style="height: 268px;" class="img-responsive center-block img_spcl" alt="{{ $rows->name }}" />
                                                </picture>
                                            </div>
                                            <div class="product_description">
                                                <h4>{{ $rows->name }}</h4>
                                                <div class="bottomPriceArea">
                                                    <p class="price" itemprop="offers" itemscope="" itemtype="http://schema.org/Offer">
                                                        <span class="specialPriceTag">Special Price</span>
                                                        <span class="newPrice"><i class="fa fa-inr" aria-hidden="true"></i> {{ number_format($rows->prepaid_amount,0) }}/-</span>
                                                        <span class="oldPrice"><i class="fa fa-inr" aria-hidden="true"></i> {{ number_format($rows->actual_price,0) }}</span>
                                                        <span class="extraOffer" style="text-decoration: initial;">{{ number_format((($rows->prepaid_amount/$rows->actual_price)*100),0) }}% off</span>
                                                    </p>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                            @endforeach        
                                </ul>
                            </div>
                        </div>
                      @endif


                    </section>
                <!-- Scroll top button // start -->
                <a href="#" class="scrollTopButton"><i class="fa fa-angle-up" aria-hidden="true"></i></a>
                <!-- Scroll top button // end -->
                <!--Footer // Start-->
            @include('storefront.partials.footer')
                <!--Footer // End-->
            </div>
        </div>
        <!--o-wrapper // End-->
        <!--Menu Left // Start-->
        <div class="dvmenu"></div>
        <!--Menu Left // End-->
        <!--Menu Right // Start-->
        <div id="rightSideMenu"></div>
        <!--Menu Right // End-->

        <div id="c-mask" class="c-mask"></div>
        <!-- /c-mask -->

        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/materializeJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/bootstrapJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/lightgalleryJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/retinaJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/swiperJs.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/menu.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/commonJsV2.js')}}"></script>
        <script rel="preload" as="script" type="text/javascript" src="{{ asset('storefront/mobile/Js/searchJs.js')}}"></script>
        <script src="{{ asset('storefront/ajax/ajax-home-sdk.js')}}"></script>
        <script>
            var EcomerceData = [];
            $(function () {
                $(".swiper-button-next").removeClass("swiper-button-disabled");
                $(".swiper-button-prev").removeClass("swiper-button-disabled");

                // Banner
                var swiper = new Swiper(".swiper-container.banner_box", {
                    slidesPerView: 1,
                    loop: true,
                    autoplay: {
                        delay: 18000,
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                });

                // Top Offer
                var swiper = new Swiper(".swiper-container.topOffers", {
                    slidesPerView: 2.5,
                    spaceBetween: 5,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        1280: {
                            slidesPerView: 7.5,
                            spaceBetween: 10,
                        },
                        1140: {
                            slidesPerView: 6,
                            spaceBetween: 8,
                        },
                        992: {
                            slidesPerView: 5,
                            spaceBetween: 8,
                        },
                        767: {
                            slidesPerView: 4,
                            spaceBetween: 5,
                        },
                        640: {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        540: {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                    },
                });

                var swiper = new Swiper(".swiper-container.feature_1", {
                    slidesPerView: 2.3,
                    spaceBetween: 15,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                });
            });
        </script>
    </body>
</html>