@extends('theme.layouts.app') @section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                        </ol>
                    </div>
                    <h4 class="page-title">Companies</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

    <form class="needs-validation parsley-examples" data-parsley-validate action="{{ route('integration.store')}}" method="POST" novalidate>
        @csrf
        <div class="row row-sm">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border"><i>Shopify Add Information</i></legend>
                            <div class="card-body">
                                <h4 class="header-title">Use the following instructions to integrate Shopify.</h4>
                                <ul class="list-group">
                                    <li class="list-group-item"><i class="mr-1"></i> 1.Login to Shopify Admin Panel.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 2.Go to Apps.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 3.Click on Private Apps Button.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 4.Click on Create Apps Button.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 5.Enter Title name under the Description tab and click on save.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 6.Click on Title, as you entered earlier.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 7.Here you will find Shopify API Key, Password,Shared, Secret.</li>
                                    <li class="list-group-item"><i class="mr-1"></i> 8.Copy the indentifiers and integrate the Channel.</li>
                                </ul>
                                <br>
                                <div class="embed-responsive embed-responsive-16by9">
                                  <iframe class="embed-responsive-item" src="https://www.youtube.com/embed/8C-vLBn9FCg?rel=0" allowfullscreen></iframe>
                                </div>                                  
                            </div>
                        </fieldset>
                    </div>
                </div>  
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                            <div class="form-group">
                                <label for="input-1">Account Name *</label>
                                <input type="text" class="form-control" name="account_name" value="{{ old('account_name') }}" placeholder="Account Name *" required  />
                                @error('account_name')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter Account Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Account API Key *</label>
                                <input type="text" class="form-control" name="api_key" value="{{ old('api_key') }}" placeholder="Account API Key *" required  />
                                @error('api_key')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback">
                                    Please Enter Account API Key.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Account Password *</label>
                                <input type="text" class="form-control" name="account_password" value="{{ old('account_password') }}" placeholder="Account Password *" required  />
                                @error('account_password')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
    
                                <div class="invalid-feedback">
                                    Please Enter Account Password.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Secret Key *</label>
                                <input type="text" class="form-control" name="secret" value="{{ old('secret') }}" placeholder="Secret Key *" required  />
                                @error('secret')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback">
                                    Please Enter Secret Key.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Account URL *</label>
                                <textarea type="text" rows="4" class="form-control" name="account_url"  placeholder="Account URL *" required>{{ old('account_url') }}</textarea>
                                                            @error('account_url')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror

                                <div class="invalid-feedback">
                                    Please Enter Account URL.
                                </div>
                            </div>
                            <div class="form-group" style="display: none;">
                                <label for="input-1">Developer Email Id (optional)</label>
                                <input type="email" class="form-control" name="emergency_developer_email" value="{{ 'mantu.it@trendydeals.in' }}" placeholder="Developer Email Id (optional)"  />
                            </div>
                            <div class="form-group"  style="display: none;">
                                <label for="input-3">A/c Type</label>
                                <select name="api_type" required class="form-control">
                                    <option value="ORDER" selected="selected">ORDER</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="input-3">Status</label>
                                <select name="is_active" required class="form-control">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        <div class="form-group">
                            <button type="submit" style="font-size: 18px;" class="btn btn-primary shadow-primary btn-block pull-right" name="submit" value="Save">Save</button>
                        </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </form>    
    </div>
    <!-- end container-fluid -->
</div>
@endsection
