@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                     <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                     <li class="breadcrumb-item">Blog</li>
                  </ol>
               </div>
            </div>
         </div>
      </div>
      <!-- end page title -->
      <div class="row">
         <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
               <div class="card-body">

                  <div class="row mb-2">
                     <div class="col-lg-12">
                        <div class="text-lg-end pull-right">
                           <a href="{{ route('product.create') }}"
                              class="btn btn-sm btn-primary waves-effect waves-light mb-2 me-2"><i
                                 class="mdi mdi-basket me-1"></i> Add New</a>
                        </div>
                     </div>
                     <!-- end col-->
                  </div>


                  <fieldset class="scheduler-border">
                     <legend align="left" class="scheduler-border">Products</legend>
                     <div class="table-responsive">
                        <table class="table table-centered table-striped dt-responsive nowrap w-100 table-sm"
                           id="products-datatable">
                           <thead class="text-left thead-info">
                              <th>S.No.</th>
                              <th>Image</th>
                              <th>Name</th>
                              <th>Status</th>
                              <th>Created at</th>
                              <th>Action</th>
                           </thead>
                           <tbody>
                              @foreach($response as $key=>$rows)
                              <form action="{{ route('product.destroy',$rows->id) }}" method="POST">
                                 @csrf @method('DELETE')
                                 <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td>
                                       <img src="{{$rows->image}}"
                                          alt="{{ $rows->name }}" height="32" />
                                    </td>

                                    <td title="{{ $rows->name }}">{{ substr($rows->name,0,30) }}</td>
                                    <td>
                                       @if($rows->is_active==1)
                                       <a href="{{ route('product.edit',$rows->id) }}?action=0" title="Inactive"
                                          onclick="return confirm('Do you want to Inactive?');">
                                          <span class="badge badge-success shadow-success m-1">Active</span>
                                       </a>
                                       @else
                                       <a href="{{ route('product.edit',$rows->id) }}?action=1" title="Active"
                                          onclick="return confirm('Do you want to Active?');">
                                          <span class="badge badge-danger shadow-danger m-1">Inactive</span>
                                       </a>
                                       @endif
                                    </td>
                                    <td>{{ $rows->created_at }}</td>
                                    <td>
                                       <a href="{{ route('product.edit',$rows->id) }}"
                                          class="btn-sm btn btn-primary btn-rounded waves-effect waves-light"
                                          title="Edit"><i class="fa fa-edit"></i></a>

                                       <button type="submit"
                                          class="btn-sm btn btn-danger btn-rounded waves-effect waves-light"
                                          title="Delete" onclick="return confirm('Do You want to Delete?')"><i
                                             class="fa fa-trash"></i></button>

                                    </td>
                                 </tr>
                              </form>
                              @endforeach
                           </tbody>
                        </table>
                        <hr />
                        <!-- {!! $response->links() !!} -->
                     </div>

                  </fieldset>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
@endsection